package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReportFromReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryStaffReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryReportFromsRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 工作总结
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Slf4j
@RestController
@RequestMapping("/summary")
@Api(tags = "小程序端-工作台页面-工作助手-工作总结")
public class SfaSummaryController {
    @Autowired
    private ISfaWorkSummaryService sfaWorkSummaryService;

    /**
     * 查询指定人员工作报告
     * @param
     * @return
     */
    @ApiOperation(value = "查询指定人员工作报告")
    @PostMapping("/queryDayOnes")
    @CrmLog
    public Result<SfaWorkSummaryRespVo> queryDayOnes(@RequestBody SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo) {

        return Result.ok(sfaWorkSummaryService.querySummaryOnes(sfaWorkSummaryStaffReqVo));
    }


    /**
     * 查询工作总结
     */
    @ApiOperation(value = "查询工作总结_首次")
    @PostMapping("/dayList")
    @CrmLog
    public Result<SfaWorkSummaryRespVo> dayList(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        return Result.ok(sfaWorkSummaryService.findTaskSummary(sfaWorkSummaryReqVo));
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryService.save(sfaWorkSummaryReqVo);
        return Result.ok();
    }


    /**
     * 工作总结报表
     */
    @ApiOperation(value = "工作总结报表")
    @PostMapping("/summaryReportFroms")
    @CrmLog
    public Result<PageResult<SfaWorkSummaryReportFromsRespVo>> summaryReportFroms(@RequestBody SfaWorkSummaryReportFromReqVo sfaWorkSummaryReportFromReqVo) {
        return Result.ok(sfaWorkSummaryService.summaryReportFroms(sfaWorkSummaryReportFromReqVo));
    }


}
