package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelApplyReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author ren.gang
 * @ClassName SfaTravelController.java
 * @Description 小程序端-工作台页面-出差
 * @createTime 2021年01月07日 13:44:00
 */
@Slf4j
@RestController
@RequestMapping("/moblie/SfaTravel")
@Api(tags = "小程序端-工作台页面-出差 ")
public class SfaTravelMoblieController {

    @Autowired
    private ISfaTravelService iSfaTravelService;

    /**
     *
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "出差申请")
    @PostMapping("/goApplyTravel")
    @CrmLog
    public Result goApplyTravel(@RequestBody SfaTravelApplyReqVo reqVo){
        Result result = iSfaTravelService.goApplyTravel(reqVo);
        return result;
    }

    @ApiOperation(value = "我的申请列表")
    @PostMapping("/findSfaTravelList")
    @CrmLog
    public Result<PageResult<SfaTravelRespVo>> findSfaTravelList(@RequestBody SfaTravelReqVo sfaLeaveReqVo) {
        PageResult<SfaTravelRespVo> result = new PageResult<>();
        //获取当前登录人信息
        UserRedis userRedis = UserUtils.getUser();
        if (null!=userRedis && StringUtil.isNotEmpty(userRedis.getUsername())){
            sfaLeaveReqVo.setMyApply(userRedis.getUsername());
            result = iSfaTravelService.findList(sfaLeaveReqVo);
        }
        return Result.ok(result);
    }

    @ApiOperation(value = "详情")
    @GetMapping("/query")
    @CrmLog
    public Result<SfaTravelRespVo> query(String id) {

        return Result.ok(iSfaTravelService.query(id));
    }

    @ApiOperation(value = "出差-追回")
    @PostMapping("/rollback")
    @CrmLog
    public Result rollback(@RequestBody CrmIdsReqVo idsReqVo) {
        AssertUtils.isNotEmpty(idsReqVo.getIds(), "业务主键不能为空");

        return iSfaTravelService.rollback(idsReqVo.getIds().get(0));
    }

}
