package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.moblie.service.ISfaWorkSignAuditService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.ReadCopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.sfa.worksign.req.*;
import com.biz.crm.nebular.sfa.worksign.resp.*;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author ren.gang
 * @ClassName SfaWorkSignAuditController.java
 * @Description 考勤审批接口
 * @createTime 2020年11月26日 14:38:00
 */
@Slf4j
@RestController
@RequestMapping("/sfaWorkSignAudit")
@Api(tags = "小程序端-考勤管理-考勤审批 ")
public class SfaWorkSignAuditController {

    @Autowired
    private ISfaWorkSignAuditService service;

    @ApiOperation("待审批汇总")
    @GetMapping("/backlogCount")
    @CrmLog
    public Result<Map<String, Integer>> backlogCount() {

        return Result.ok(service.backlogCount());
    }

    @ApiOperation("提交审核信息")
    @PostMapping("/auditCommit")
    @CrmLog
    public Result auditCommit(@RequestBody SfaAuditReqVo reqVo) {
        return service.auditCommit(reqVo);
    }

    @ApiOperation(value = "请假审批-列表")
    @PostMapping("/auditListLeave")
    @CrmLog
    public Result<PageResult<SfaAuditListLeaveRespVo>> auditListLeave(@RequestBody SfaLeaveListReqVo reqVo) {
        return Result.ok(service.auditListLeave(reqVo));
    }

    @ApiOperation(value = "工作日调整-列表")
    @PostMapping("/auditListOvertime")
    @CrmLog
    public Result<PageResult<SfaAuditListOvertimeRespVo>> auditListOvertime(@RequestBody SfaWorkOvertimeListReqVo reqVo) {
        return Result.ok(service.auditListOvertime(reqVo));
    }

    @ApiOperation(value = "异常报备-列表")
    @PostMapping("/auditListException")
    @CrmLog
    public Result<PageResult<SfaAuditListExceptionRespVo>> auditListException(@RequestBody SfaExceptionReportListReqVo reqVo) {
        return Result.ok(service.auditListException(reqVo));
    }

    @ApiOperation(value = "销假审批-列表")
    @PostMapping("/auditListLeaveCancel")
    @CrmLog
    public Result<PageResult<SfaAuditListLeaveCancelRespVo>> auditListLeaveCancel(@RequestBody SfaAuditListLeaveCancelReqVo reqVo) {
        return Result.ok(service.auditListLeaveCancel(reqVo));
    }

    @ApiOperation(value = "出差审批-列表")
    @PostMapping("/auditListTravel")
    @CrmLog
    public Result<PageResult<SfaAuditListTravelRespVo>> auditListTravel(@RequestBody SfaTravelReqVo reqVo) {
        return Result.ok(service.auditListTravel(reqVo));
    }


    @ApiOperation("抄送给我的-列表")
    @PostMapping("/copyTaskList")
    @CrmLog
    public Result<PageResult<SfaCopyTaskRespVo>> copyTaskList(@RequestBody SfaCopyTaskReqVo reqVO) {

        return Result.ok(service.copyTaskList(reqVO));
    }

    @ApiOperation(value = "抄送节点已阅")
    @PostMapping("/readCopyTask")
    @CrmLog
    public Result readCopyTask(@RequestBody ReadCopyTaskReqVO readCopyTaskReqVO){

        return service.readCopyTask(readCopyTaskReqVO);
    }

    @ApiOperation(value = "查询流程审批记录")
    @PostMapping("/findAuditRecords")
    @CrmLog
    public Result<List<OptRecordRspVO>> findAuditRecords(@RequestBody SfaAuditReportListReqVo reqVo){
        return Result.ok(service.findAuditRecords(reqVo));
    }

    @ApiOperation(value = "查询流程详细信息")
    @PostMapping("/getProcessInfo")
    @CrmLog
    public Result<ProcessInfoRspVO> getProcessInfo(@RequestBody SfaAuditReportListReqVo reqVo) {
        return Result.ok(service.getProcessInfo(reqVo));
    }

    @ApiOperation("请假审核流程结束")
    @PostMapping("/leaveEnd")
    @CrmLog
    public Result leaveEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {

        return auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.LEAVE);
    }

    @ApiOperation("工作日调整审核流程结束")
    @PostMapping("/overtimeEnd")
    @CrmLog
    public Result overtimeEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {

        return auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.OVERTIME);
    }

    @ApiOperation("异常报备审核流程结束")
    @PostMapping("/exceptionEnd")
    @CrmLog
    public Result exceptionEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {

        return auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.EXCEPTION);
    }

    @ApiOperation("销假审核流程结束")
    @PostMapping("/leaveCancelEnd")
    @CrmLog
    public Result leaveCancelEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {

        return auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.LEAVECANCEL);
    }



    @ApiOperation("出差审核流程结束")
    @PostMapping("/travelEnd")
    @CrmLog
    public Result travelEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {

        return auditFinish(activitiCallBackVo, ActivitiEnum.FormTypeEnum.TRAVEL);
    }

    /**
     * 调用审核完成接口
     * @param activitiCallBackVo
     * @param formTypeEnum
     * @return
     */
    private Result auditFinish(ActivitiCallBackVo activitiCallBackVo, ActivitiEnum.FormTypeEnum formTypeEnum) {
        SfaAuditFinishReqVo reqVo = new SfaAuditFinishReqVo();
        reqVo.setCostType(formTypeEnum.getCostType());
        reqVo.setFormId(activitiCallBackVo.getFormNo());
        if (activitiCallBackVo.getProcessState() == 2) {
            reqVo.setResult(ActivitiEnum.AuditResultType.PASS.getVal());
        } else if (activitiCallBackVo.getProcessState() == 3) {
            reqVo.setResult(ActivitiEnum.AuditResultType.REJECT.getVal());
        } else if (activitiCallBackVo.getProcessState() == 5){
            reqVo.setResult(ActivitiEnum.AuditResultType.RECOVER.getVal());
        }
        if(StringUtils.isNotEmpty(reqVo.getResult())) {
            service.auditFinish(reqVo);
        }

        return Result.ok();
    }


}
