package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.*;
import com.biz.crm.nebular.sfa.worksign.resp.*;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 小程序端-工作台页面-考勤管理-工作日调整相关接口
 *
 * @author ren.gang
 * @date 2020-11-20 15:05:08
 */
@Slf4j
@RestController
@RequestMapping("/SfaWorkSignWorkOvertimeController")
@Api(tags = "小程序端-考勤管理-工作日调整 ")
public class SfaWorkSignWorkOvertimeController {

    @Autowired
    private ISfaWorkOvertimeService service;

    @ApiOperation(value = "列表查询-我的提交的")
    @PostMapping("/findSfaBpmList")
    @CrmLog
    public Result<PageResult<SfaWorkOvertimeRespVo>> findSfaLeaveBpmList(@RequestBody SfaWorkOvertimeListReqVo reqVo) {
        PageResult<SfaWorkOvertimeRespVo> result = new PageResult<>();
        // 默认查询当前登录人员申请
        if(StringUtils.isEmpty(reqVo.getUserName())) {
            reqVo.setUserName(UserUtils.getUser().getUsername());
        }
        result = service.findList(reqVo);

        return Result.ok(result);
    }

    @ApiOperation(value = "申请详情查询")
    @PostMapping("/findSfaById")
    @CrmLog
    public Result<SfaWorkOvertimeRespVo> findSfaLeaveById(@RequestBody CrmIdsReqVo idsReqVo) {
        Result<SfaWorkOvertimeRespVo> result = new Result();
        if(idsReqVo == null || idsReqVo.getIds() == null || idsReqVo.getIds().size() == 0) {
            result.error500("请输入业务主键");
            return result;
        }

        result.setResult(service.query(idsReqVo.getIds().get(0)));
        return result;
    }


    @ApiOperation(value = "提交申请接口")
    @PostMapping("/apply")
    @CrmLog
    public Result apply(@RequestBody SfaWorkOvertimeReqVo reqVo){
        Result result = service.apply(reqVo);
        return result;
    }

    @ApiOperation(value = "申请追回")
    @PostMapping("/rollback")
    @CrmLog
    public Result rollbackLeave(@RequestBody CrmIdsReqVo idsReqVo) {
        if(idsReqVo == null || idsReqVo.getIds() == null || idsReqVo.getIds().size() == 0) {
            return Result.error("业务主键不能为空");
        }

        return service.rollback(idsReqVo.getIds().get(0));
    }

}
