package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 工作总结 
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@RestController
@RequestMapping("/sfaworksummary")
@Api(tags = "工作总结 ")
public class SfaWorkSummaryController {
    @Autowired
    private ISfaWorkSummaryService sfaWorkSummaryService;




    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmAPIDiscard
    public Result<SfaWorkSummaryRespVo> query(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        SfaWorkSummaryRespVo respVo=sfaWorkSummaryService.query(sfaWorkSummaryReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    @CrmAPIDiscard
    public Result save(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryService.save(sfaWorkSummaryReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @CrmAPIDiscard
    public Result update(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryService.update(sfaWorkSummaryReqVo);
        return Result.ok("修改成功");
    }


}
