package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.assistant.service.ISfaWorkTaskReceveService;
import com.biz.crm.assistant.service.ISfaWorkTaskReleaseService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReportReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReportRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 工作任务(接收) 
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@RestController
@RequestMapping("/sfaworktaskreceve")
@Api(tags = "工作任务(接收) ")
public class SfaWorkTaskReceveController {
    @Resource
    private ISfaWorkTaskReceveService sfaWorkTaskReceveService;
    @Resource
    private ISfaWorkTaskReleaseService sfaWorkTaskReleaseService;


    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkTaskReceveRespVo>> list(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) throws Exception{
        return Result.ok(sfaWorkTaskReceveService.findList(sfaWorkTaskReceveReqVo));
    }


    /**
     * 日程任务列表
     */
    @ApiOperation(value = "查询日程任务列表")
    @PostMapping("/daylist")
    @CrmLog
    public Result<PageResult<SfaWorkTaskReceveRespVo>> dayList(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) throws Exception{
        return Result.ok(sfaWorkTaskReceveService.findDayList(sfaWorkTaskReceveReqVo));
    }

    /**
     * 日程任务进度
     */
    @ApiOperation(value = "查询日程任务进度")
    @PostMapping("/dayPlan")
    @CrmLog
    public Result<Map> dayPlan(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo){
        return Result.ok(sfaWorkTaskReceveService.findDayPlan(sfaWorkTaskReceveReqVo));
    }

    @ApiOperation(value = "日程/接收 查询详情",httpMethod = "GET")
    @GetMapping("/query")
    @CrmLog
    public Result<SfaWorkTaskReleaseRespVo> query(@RequestParam("receveId") String receveId) {
        SfaWorkTaskReleaseRespVo respVo = sfaWorkTaskReleaseService.queryForUserReceve(receveId);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    @CrmAPIDiscard
    public Result save(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
        sfaWorkTaskReceveService.save(sfaWorkTaskReceveReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "日程状态变更")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
        sfaWorkTaskReceveService.update(sfaWorkTaskReceveReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 查询工作任务报表
     * @param reqVo
     * @return
     */
    @ApiOperation("查询工作任务报表")
    @PostMapping("findSfaWorkTaskReportList")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaWorkTaskReportRespVo>> findSfaWorkTaskReportList(@RequestBody SfaWorkTaskReportReqVo reqVo){
        return Result.ok(sfaWorkTaskReceveService.findSfaWorkTaskReportList(reqVo));
    }

    /**
     * 查看报表详情
     * @param id
     * @return
     */
    @ApiOperation("查看报表详情")
    @GetMapping("querySfaWorkTaskReport")
    @CrmLog
    @CrmDictMethod
    public Result<SfaWorkTaskReportRespVo> querySfaWorkTaskReport(@RequestParam("id") String id){
        return Result.ok(sfaWorkTaskReceveService.findSfaWorkTaskReportById(id));
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    @CrmAPIDiscard
    public Result delete(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
//        sfaWorkTaskReceveService.deleteBatch(sfaWorkTaskReceveReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    @CrmAPIDiscard
    public Result enable(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
//        sfaWorkTaskReceveService.enableBatch(sfaWorkTaskReceveReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    @CrmAPIDiscard
    public Result disable(@RequestBody  SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
//        sfaWorkTaskReceveService.disableBatch(sfaWorkTaskReceveReqVo);
        return Result.ok("禁用成功");
    }
}
