package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.assistant.service.ISfaWorkTaskReleaseService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReleaseReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 工作任务(发布) 
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@RestController
@RequestMapping("/sfaworktaskrelease")
@Api(tags = "工作任务(发布) ")
public class SfaWorkTaskReleaseController {
    @Autowired
    private ISfaWorkTaskReleaseService sfaWorkTaskReleaseService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkTaskReleaseRespVo>> list(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
        return Result.ok(sfaWorkTaskReleaseService.findListAll(sfaWorkTaskReleaseReqVo));
    }
    /**
     * 查询
     */
    @ApiOperation(value = "发布 查询详情",httpMethod = "GET")
    @GetMapping("/query")
    @CrmLog
    public Result<SfaWorkTaskReleaseRespVo> query(@RequestParam("id") String id) {
        SfaWorkTaskReleaseRespVo respVo=sfaWorkTaskReleaseService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "工作任务新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
        sfaWorkTaskReleaseService.save(sfaWorkTaskReleaseReqVo);
        return Result.ok();
    }

}
