package com.biz.crm.moblie.controller.summary;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryCommentReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryCommentRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.worksummary.service.ISfaWorkSummaryCommentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 工作总结评论记录
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@RestController
@RequestMapping("/sfawork-summary-comment-api")
@Api(tags = "Mobile工作总结评论")
public class SfaWorkSummaryCommentApiController {
    @Autowired
    private ISfaWorkSummaryCommentService sfaWorkSummaryCommentService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSummaryCommentRespVo>> list(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        PageResult<SfaWorkSummaryCommentRespVo> result=sfaWorkSummaryCommentService.findList(sfaWorkSummaryCommentReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSummaryCommentRespVo> query(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        SfaWorkSummaryCommentRespVo respVo=sfaWorkSummaryCommentService.query(sfaWorkSummaryCommentReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.save(sfaWorkSummaryCommentReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.update(sfaWorkSummaryCommentReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.deleteBatch(sfaWorkSummaryCommentReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.enableBatch(sfaWorkSummaryCommentReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.disableBatch(sfaWorkSummaryCommentReqVo);
        return Result.ok("禁用成功");
    }
}
