package com.biz.crm.moblie.controller.visit;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.service.ISfaVisitHelpDefenseService;
import com.biz.crm.moblie.controller.visit.component.impl.HelpScoreVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.HelpScoreStepExecuteDataResp;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.helpdefense.req.*;
import com.biz.crm.nebular.sfa.helpdefense.resp.FindHelpDefenseScheduleRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaVisitHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.step.LoadHelpDefenseExecutionInfoRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lf
 * @describe 计算薪资日期日志表实体类
 * @project crm
 * @package com.biz.crm.moblie.controller
 * @date 2021/1/11 16:08
 */
@RestController
@RequestMapping("SfaVisitHelpController")
@Slf4j
@Api(tags = "小程序端-日程页面-协访执行")
public class SfaVisitHelpController {

    @Resource
    private ISfaVisitHelpDefenseService sfaVisitHelpDefenseService;
    @Resource
    private HelpScoreVisitStepExecutor helpScoreVisitStepExecutor;

    /**
     * 拜访步骤-协访评价
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "拜访步骤-协访评价")
    @PostMapping("/saveVisitStepHelpScore")
    @CrmLog
    public Result saveVisitStepCompetitor(@RequestBody VisitStepExecuteReq<HelpScoreStepExecuteData> visitStepExecuteReq){

        helpScoreVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }
    /**
     * 拜访步骤-协访评价
     * @param redisHashKey
     * @return
     */
    @ApiOperation(value = "拜访步骤-协访评价-查询表单执行数据")
    @PostMapping("/loadVisitStepHelpScore")
    @CrmLog
    public Result<HelpScoreStepExecuteDataResp> loadVisitStepCompetitor(@RequestBody ExecutorLoadReq redisHashKey){
        HelpScoreStepExecuteDataResp dataResp = (HelpScoreStepExecuteDataResp)helpScoreVisitStepExecutor.load(redisHashKey);
        return Result.ok(dataResp);
    }

    @CrmLog
    @PostMapping("loadInfoPageData")
    @ApiOperation("查询协访评价详细信息")
    public Result<HelpScoreStepExecuteDataResp> loadInfoPageData(@RequestBody ExecutorWorkbenchLoadReq loadParam){
        HelpScoreStepExecuteDataResp dataResp = (HelpScoreStepExecuteDataResp) helpScoreVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        return Result.ok(dataResp);
    }


    /**
     * 协访模块接口-协访步骤执行
     * @return
     */
    @CrmLog
    @ApiOperation(value = "协访模块接口-协访步骤执行")
    @PostMapping("saveHelpDefenseDetail")
    @Deprecated
    @CrmAPIDiscard
    public Result saveHelpDefenseDetail(@RequestBody SfaVisitHelpDefenseDetailReqVo reqVo){
        sfaVisitHelpDefenseService.saveHelpDefenseDetail(reqVo);
        return Result.ok();
    }

    /**
     * 保存协防-总结
     * @param reqVo
     * @return
     */
    @CrmLog
    @ApiOperation(value = "协防-保存协防总结/重大问题记录")
    @PostMapping("saveHelpDefenseSummary")
    @Deprecated
    @CrmAPIDiscard
    public Result saveHelpDefenseSummary(@RequestBody SfaVisitHelpDefenseReqVo reqVo){
        sfaVisitHelpDefenseService.saveHelpDefenseSummary(reqVo);
        return Result.ok();
    }


    /**
     * 查询协防列表
     * @param reqVo
     * @return
     */
    @CrmLog
    @PostMapping("findVisitHelpDefenseList")
    @ApiOperation(value = "查询协防列表")
    @Deprecated
    @CrmAPIDiscard
    public Result<PageResult<SfaVisitHelpDefenseRespVo>> findVisitHelpDefenseList(@RequestBody FindVisitHelpDefenseListReqVo reqVo){
        PageResult<SfaVisitHelpDefenseRespVo> pageResult = sfaVisitHelpDefenseService.findVisitHelpDefenseList(reqVo);
        return Result.ok(pageResult);
    }

    /**
     * 查询协防进度
     * @return
     */
    @CrmLog
    @ApiOperation(value = "协防进度")
    @PostMapping("findHelpDefenseSchedule")
    @Deprecated
    @CrmAPIDiscard
    public Result<FindHelpDefenseScheduleRespVo> findHelpDefenseSchedule(@RequestBody FindHelpDefenseScheduleReqVo reqVo){
        FindHelpDefenseScheduleRespVo respVo = sfaVisitHelpDefenseService.findHelpDefenseSchedule(reqVo);
        return Result.ok(respVo);
    }

    /**
     * 协防-进店打卡
     * @param reqVo
     * @return
     */
    @CrmLog
    @ApiOperation(value = "协防-进店打卡")
    @PostMapping("helpDefenseInStore")
    @Deprecated
    @CrmAPIDiscard
    public Result<String> helpDefenseInStore(@RequestBody HelpDefenseInStoreReqVo reqVo){
        String id = sfaVisitHelpDefenseService.helpDefenseInStore(reqVo);
        Result result = new Result();
        result.setResult(id);
        return result;
    }

    /**
     * 查询协防步骤列表
     * @param id
     * @return
     */
    @CrmLog
    @ApiOperation(value = "查询协防步骤列表")
    @GetMapping("findHelpDefenseROleDirectory")
    @Deprecated
    @CrmAPIDiscard
    public Result<List<SfaVisitRoleDirectoryRespVo>> findHelpDefenseROleDirectory(String id){
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = sfaVisitHelpDefenseService.findHelpDefenseROleDirectory(id);
        return Result.ok(sfaVisitRoleDirectoryRespVos);
    }
    /**
     * 加载协访任务执行信息
     * @param id
     * @return
     */
    @CrmLog
    @ApiOperation(value = "加载协访任务执行信息")
    @GetMapping("loadHelpDefenseExecutionInfo")
    @Deprecated
    @CrmAPIDiscard
    public Result<LoadHelpDefenseExecutionInfoRespVo> loadHelpDefenseExecutionInfo(String id){
        LoadHelpDefenseExecutionInfoRespVo loadHelpDefenseExecutionInfoRespVo = sfaVisitHelpDefenseService.loadHelpDefenseExecutionInfo(id);
        return Result.ok(loadHelpDefenseExecutionInfoRespVo);
    }
    /**
     * 协防-离店打卡
     * @param reqVo
     * @return
     */
    @CrmLog
    @PostMapping("helpDefenseOutStore")
    @ApiOperation(value = "协防-离店打卡")
    @Deprecated
    @CrmAPIDiscard
    public Result helpDefenseOutStore(@RequestBody SfaVisitHelpDefenseReqVo reqVo){
        sfaVisitHelpDefenseService.helpDefenseOutStore(reqVo);
        return Result.ok();
    }



    /**
     * 协防-查询协防详细信息
     * @param id
     * @return
     */
    @CrmLog
    @GetMapping("queryHelpDefenseDetail")
    @ApiOperation(value = "协防-查询协防详细信息")
    @Deprecated
    @CrmAPIDiscard
    public Result<SfaVisitHelpDefenseRespVo> queryHelpDefenseDetail(String id){
        SfaVisitHelpDefenseRespVo sfaVisitHelpDefenseRespVo = sfaVisitHelpDefenseService.queryHelpDefenseDetail(id);
        return Result.ok(sfaVisitHelpDefenseRespVo);
    }
}
