package com.biz.crm.moblie.controller.visit;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.moblie.service.ISfaVisitOffLineService;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOffLineDataVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.controller.visit
 * @date 2021/6/23 15:19
 */
@RestController
@RequestMapping("/sfaVisitOffLineController")
@Api(tags = "小程序-拜访执行-离线数据")
public class SfaVisitOffLineController {

    @Autowired
    private ISfaVisitOffLineService sfaVisitOffLineService;


    @ApiOperation(value = "获取拜访离线数据")
    @CrmLog
    @PostMapping("getVisitOffLineData")
    public Result<VisitOffLineDataVo> getVisitOffLineData(@RequestBody CrmRedisHashKeyVo redisHashKeyVo){
        return Result.ok(sfaVisitOffLineService.getVisitOffLineData(redisHashKeyVo));
    }


    @CrmLog
    @ApiOperation(value = "离线数据保存-离店打卡除外")
    @PostMapping("saveVisitOffLineData")
    public Result saveVisitOffLineData(@RequestBody List<SfaVisitOffLineReqVo> reqVoList){
        sfaVisitOffLineService.saveVisitOffLineData(reqVoList);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "离线文件保存")
    @PostMapping("saveOffLineFile")
    public Result saveOffLineFile(@RequestBody List<AttachmentOffLineVo> list){
        sfaVisitOffLineService.saveOffLineFile(list);
        return Result.ok();
    }
}
