package com.biz.crm.moblie.controller.visit.component;


import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 拜访计划明细监听器
 *  @author: luoqi
 *  @Date: 2021-4-8 10:43
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
public abstract class AbstractVisitInfoPlanListener implements VisitInfoPlanListener{
    /**
     * 步骤监听器注册容器
     */
    protected static final Map<String, Set<Class<? extends AbstractVisitInfoPlanListener>>> VISIT_STEP_LISTENER_CLASS_MAPPING = new HashMap<>();

    /**
     * 获取指定拜访大类的监听器列表
     * @param visitBigType
     * @return
     */
    public static List<AbstractVisitInfoPlanListener> getListeners(String visitBigType){
        List<Class<? extends AbstractVisitInfoPlanListener>> clazz = getListenerClazz(visitBigType);
        List<AbstractVisitInfoPlanListener> listeners = Lists.newArrayList();
        for (Class<? extends AbstractVisitInfoPlanListener> aClass : clazz) {
            if(null == aClass){
                continue;
            }
            AbstractVisitInfoPlanListener listener = SpringApplicationContextUtil.getApplicationContext().getBean(aClass);
            if(null == listener){
                log.warn("未获取到拜访计划明细监听器[" + aClass.getName() + "]的实例,忽略该监听器！");
            }
            listeners.add(listener);
        }
        return listeners;
    }

    /**
     * 获取指定拜访大类的监听器class
     * @param visitBigType
     * @return
     */
    public static List<Class<? extends AbstractVisitInfoPlanListener>> getListenerClazz(String visitBigType){
        List<Class<? extends AbstractVisitInfoPlanListener>> classes = Lists.newArrayList();
        Set<Class<? extends AbstractVisitInfoPlanListener>> temp = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitBigType);
        if(null != temp){
            classes.addAll(temp);
        }
        temp = VISIT_STEP_LISTENER_CLASS_MAPPING.get(SfaVisitEnum.VisitBigType.LISTENER_ALL);
        if(null != temp){
            classes.addAll(temp);
        }
        return classes;
    }



    @PostConstruct
    public final void constructed(){
        Set<String> visitBigTypes = this.visitBigTypeRegistry();
        if(CollectionUtils.isEmpty(visitBigTypes)){
            throw new BusinessException("拜访计划明细监听器注册失败: 请指定监听器[" + this.getClass().getName()
                    + "]的拜访大类编码");
        }

        for (String visitBigType : visitBigTypes) {
            if(StringUtils.isBlank(visitBigType)){
                throw new BusinessException("拜访计划明细监听器注册失败: 监听器[" + this.getClass().getName()
                        + "]指定了空值的拜访大类编码");
            }
            Set<Class<? extends AbstractVisitInfoPlanListener>> classes = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitBigType);
            if(null == classes){
                classes = Sets.newHashSet();
            }
            classes.add(this.getClass());
            VISIT_STEP_LISTENER_CLASS_MAPPING.put(visitBigType, classes);
        }

    }

    /**
     *
     * 拜访大类监听器注册
     * 请返回该监听器对应的拜访大类编码[SfaVisitEnum.VisitBigType]
     * 如果需要监听全部大类，则返回 SfaVisitEnum.VisitBigType.LISTENER_ALL
     * @return
     */
    protected abstract Set<String> visitBigTypeRegistry();


    /**
     * 触发监听事件
     * @param sfaVisitPlanInfoEntity
     * @param sfaVisitPlanInfoRedisData
     */
    public void doListenerEvent(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData){
        DoneEvent doneEvent = new DoneEvent();
        doneEvent.setPlanInfoEntity(sfaVisitPlanInfoEntity);
        doneEvent.setSfaVisitPlanInfoRedisData(sfaVisitPlanInfoRedisData);
        if(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType())){
            if(SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())){
                //开始
                this.begin(doneEvent);
            }
            if(SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())
                    || SfaVisitEnum.HelpVisitStatus.EX.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())){
                //完成、异常提报
                this.committed(doneEvent);
            }
            if(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())){
                //计划未完成事件(拜访中未主动提交数据)
                this.noCommit(doneEvent);
            }
            if(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())){
                //计划过期事件
                this.overdue(doneEvent);
            }
        }else{
            if(SfaVisitEnum.visitStatus.V2.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())){
                //开始
                this.begin(doneEvent);
            }
            if(SfaVisitEnum.visitStatus.V3.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())
                    || SfaVisitEnum.visitStatus.V4.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())){
                //完成、异常提报
                this.committed(doneEvent);
            }
            if(SfaVisitEnum.visitStatus.V5.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())){
                //计划未完成事件(拜访中未主动提交数据)
                this.noCommit(doneEvent);
            }
            if(SfaVisitEnum.visitStatus.V6.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())){
                //计划过期事件
                this.overdue(doneEvent);
            }
        }
    }

}
