package com.biz.crm.moblie.controller.visit.component;


import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 步骤监听器
 *  @author: luoqi
 *  @Date: 2021-4-8 10:43
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
public abstract class AbstractVisitStepListener implements VisitStepListener{
    /**
     * 步骤监听器注册容器
     */
    protected static final Map<String, Set<Class<? extends AbstractVisitStepListener>>> VISIT_STEP_LISTENER_CLASS_MAPPING = new HashMap<>();

    /**
     * 获取指定步骤的监听器列表
     * @param visitStepCode
     * @return
     */
    public static List<AbstractVisitStepListener> getListeners(String visitStepCode){
        List<Class<? extends AbstractVisitStepListener>> clazz = getListenerClazz(visitStepCode);
        List<AbstractVisitStepListener> listeners = Lists.newArrayList();
        for (Class<? extends AbstractVisitStepListener> aClass : clazz) {
            if(null == aClass){
                continue;
            }
            AbstractVisitStepListener listener = SpringApplicationContextUtil.getApplicationContext().getBean(aClass);
            if(null == listener){
                log.warn("未获取到步骤监听器[" + aClass.getName() + "]的实例,忽略该监听器！");
            }
            listeners.add(listener);
        }
        return listeners;
    }

    /**
     * 获取指定步骤的监听器class
     * @param visitStepCode
     * @return
     */
    public static List<Class<? extends AbstractVisitStepListener>> getListenerClazz(String visitStepCode){
        List<Class<? extends AbstractVisitStepListener>> classes = Lists.newArrayList();
        Set<Class<? extends AbstractVisitStepListener>> temp = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitStepCode);
        if(null != temp){
            classes.addAll(temp);
        }
        temp = VISIT_STEP_LISTENER_CLASS_MAPPING.get(SfaCodeEnum.VisitStepCode.LISTENER_ALL);
        if(null != temp){
            classes.addAll(temp);
        }
        return classes;
    }



    @PostConstruct
    public final void constructed(){
        Set<String> visitStepCodes = this.visitStepCodeRegistry();
        if(CollectionUtils.isEmpty(visitStepCodes)){
            throw new BusinessException("拜访步骤监听器注册失败: 请指定步骤监听器[" + this.getClass().getName()
                    + "]的拜访步骤编码");
        }

        for (String visitStepCode : visitStepCodes) {
            if(StringUtils.isBlank(visitStepCode)){
                throw new BusinessException("拜访步骤监听器注册失败: 监听器[" + this.getClass().getName()
                        + "]指定了空值的拜访步骤编码");
            }
            Set<Class<? extends AbstractVisitStepListener>> classes = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitStepCode);
            if(null == classes){
                classes = Sets.newHashSet();
            }
            classes.add(this.getClass());
            VISIT_STEP_LISTENER_CLASS_MAPPING.put(visitStepCode, classes);
        }

    }
    /**
     * 拜访步骤监听器注册，
     * 请返回该步骤监听器对应的拜访步骤编码[SfaCodeEnum.VisitStepCode]
     * 如果需要监听全部大类，则返回 SfaVisitEnum.VisitStepCode.LISTENER_ALL
     * @return
     */
    protected abstract Set<String> visitStepCodeRegistry();

}
