package com.biz.crm.moblie.controller.visit.component;


import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import lombok.Data;

import java.util.List;

/**
 * 步骤监听器
 *  @author: luoqi
 *  @Date: 2021-4-8 10:43
 *  @version: V1.0
 *  @Description:
 */
public interface VisitStepListener {
    /**
     * ############## 该事件还未触发,后期实现 ##############
     * 拜访执行，用户有可能反复编辑后提交多次，生成多个事件。
     * 该事件的业务数据完全在redis缓存里操作，不会持久化到数据库
     * @param doneEvent
     */
    void visitDone(VisitStepListenerDoneEvent doneEvent);

    /**
     * 拜访提交(包括工作台的业务事件)，持久化到数据库（用户有可能会反复编辑，生成多个事件）
     * @param committedEvent
     */
    void committed(VisitStepListenerCommittedEvent committedEvent);


    /**
     * 拜访步骤监听事件
     *  @author: luoqi
     *  @Date: 2021-4-8 14:53
     *  @version: V1.0
     *  @Description:
     */
    @Data
    class VisitStepListenerEvent{
    }

    /**
     * 拜访执行监听事件
     *  @author: luoqi
     *  @Date: 2021-4-8 14:53
     *  @version: V1.0
     *  @Description:
     */
    @Data
    class VisitStepListenerDoneEvent extends VisitStepListenerEvent{
        /** 执行参数 */
        private VisitStepExecuteReq.StepExecuteDataReq stepExecuteDataReq;
    }

    /**
     * 步骤提交(包括工作台的业务事件)监听事件
     *  @author: luoqi
     *  @Date: 2021-4-8 14:53
     *  @version: V1.0
     *  @Description:
     */
    @Data
    class VisitStepListenerCommittedEvent extends VisitStepListenerEvent{
        /** 业务执行数据列表 */
        private List<? extends VisitStepListenerCommittedData> entities;
    }


    /**
     * 步骤提交(包括工作台的业务事件)业务执行数据抽象
     *  @author: luoqi
     *  @Date: 2021-4-11 19:16
     *  @version: V1.0
     *  @Description:
     */
    interface VisitStepListenerCommittedData{

        String getId();

        void setId(String id);


        String getVisitPlanInfoId();

        void setVisitPlanInfoId(String visitPlanInfoId);

        String getStepCode();

        void setStepCode(String stepCode);

        String getClientCode();

        void setClientCode(String clientCode);

        String getClientName();

        void setClientName(String clientName);

        String getClientType();

        void setClientType(String clientType);

        String getClientTypeName();

        void setClientTypeName(String clientTypeName);

        String getClientSubclass();

        void setClientSubclass(String clientSubclass);

        String getClientSubclassName();

        void setClientSubclassName(String clientSubclassName);

        default String getClientPhoto(){return null;}

        default void setClientPhoto(String clientPhoto){}

        default String getClientPhone(){return null;}

        default void setClientPhone(String clientPhone){}

        default String getUserName(){return null;}

        default void setUserName(String userName){}

        default String getRealName(){return null;}

        default void setRealName(String realName){}

        default String getPosCode(){return null;}

        default void setPosCode(String posCode){}

        default String getPosName(){return null;}

        default void setPosName(String posName){}

        default String getOrgCode(){return null;}

        default void setOrgCode(String orgCode){}

        default String getOrgName(){return null;}

        default void setOrgName(String orgName){}

        default String activityTime(){return null;}

        default void setActivityTime(String activityTime){}

        static void copyClientData(VisitStepListenerCommittedData data, SfaClientData clientData){
            if(null == data || null == clientData){
                return;
            }
            data.setClientSubclassName(clientData.getClientSubclassName());
            data.setClientSubclass(clientData.getClientSubclass());
            data.setClientTypeName(clientData.getClientTypeName());
            data.setClientType(clientData.getClientType());
            data.setClientName(clientData.getClientName());
            data.setClientCode(clientData.getClientCode());
            data.setClientPhoto(clientData.getClientPhoto());
            data.setClientPhone(clientData.getClientPhone());

        }
    }
}
