package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.*;
import com.biz.crm.visitstep.repositories.SfaVisitStepDefaultEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Optional;


/**
 * 拜访步骤执行器-默认步骤模板
 *  @author: luoqi
 *  @Date: 2021-3-5 16:13
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component()
@ConditionalOnMissingBean(name = "defaultVisitStepExecutorExpandImpl")
public class DefaultVisitStepExecutor<ExecuteReq extends SfaVisitStepDefaultEntity> extends AbstractVisitStepRedisExecutor<ExecuteReq, SfaVisitStepDefaultEsData, ExecutorLoadReq> {

    @Resource
    private SfaVisitStepDefaultEsDataRepositories sfaVisitStepDefaultEsDataRepositories;

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_DEF.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepDefaultRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());

        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        super.check(visitStepExecuteReq);
        SfaVisitStepDefaultRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());

        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }


    /**
     * 工作台-店面检查-执行
     * @param visitStepExecuteReq
     */
    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        String id = UUIDGenerator.generate();
        visitStepExecuteReq.setRedisHashKey(id);
        this.check(null, visitStepExecuteReq);
        SfaVisitStepDefaultRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        SfaVisitStepDefaultEntity dataReq = visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        redisData.setId(id);
        redisData.setVisitPlanInfoId(id);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList(redisData), fromRespVo);
    }

    /**
     * 组装 RedisData 数据对象
     * @param visitStepExecuteReq
     * @return
     */
    protected SfaVisitStepDefaultRedisData buildRedisData(VisitStepExecuteReq<? extends SfaVisitStepDefaultEntity> visitStepExecuteReq){
        SfaVisitStepDefaultEntity executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepDefaultRedisData redisData = CrmBeanUtil.copy(executeData, SfaVisitStepDefaultRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        return redisData;
    }

    /**
     * 步骤执行数据加载
     *
     * @param redisHashKey
     */
    @Override
    protected SfaVisitStepDefaultEsData doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepDefaultRedisData redisData = (SfaVisitStepDefaultRedisData)this.redisService
                .hmget(SfaVisitStepDefaultRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), redisHashKey.getRedisHashKey());
        if(null == redisData){
            SfaVisitStepDefaultEsData dataResp = new SfaVisitStepDefaultEsData(){{
                this.initAttachmentExt6();
            }};
            dataResp.setSfaVisitStepFrom(fromRespVo);
            return dataResp;
        }
        SfaVisitStepDefaultEsData dataResp = CrmBeanUtil.copy(redisData, SfaVisitStepDefaultEsData.class);
        dataResp.setAttachmentExt1(redisData.getAttachmentExt1());
        dataResp.setAttachmentExt2(redisData.getAttachmentExt2());
        dataResp.setAttachmentExt3(redisData.getAttachmentExt3());
        dataResp.setAttachmentExt4(redisData.getAttachmentExt4());
        dataResp.setAttachmentExt5(redisData.getAttachmentExt5());
        dataResp.setAttachmentExt6(redisData.getAttachmentExt6());

        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }


    /**
     * 查询ES的执行数据
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        StepExecuteDataResp esData = this.sfaVisitStepDefaultEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }



    /**
     * 查询ES的执行数据
     * @param id
     * @return
     */
    @Override
    public SfaVisitStepDefaultEsData getEsDataById(String id) {
        Optional<SfaVisitStepDefaultEsData> optional = this.sfaVisitStepDefaultEsDataRepositories.findById(id);
        if(optional.isPresent()){
            return optional.get();
        }else{
            throw new BusinessException("未查询到该数据详细信息!");
        }
    }
    /**
     * 加载工作台编辑页面数据
     *
     * @param loadParam
     */
    @Override
    protected SfaVisitStepDefaultEsData doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {

        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if(StringUtils.isNotBlank(visitPlanInfoId)){
            if(StringUtils.isBlank(loadParam.getStepCode())){
                throw new BusinessException("步骤编码为空");
            }
            SfaVisitStepDefaultEsData redisData = (SfaVisitStepDefaultEsData) this.getEsDataByVisitPlanInfo(visitPlanInfoId, loadParam.getStepCode());
            return redisData;
        }
        if(StringUtils.isBlank(bizId)){
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if(StringUtils.isBlank(loadParam.getStepCode())){
                throw new BusinessException("步骤编码为空");
            }
            SfaVisitStepDefaultEsData dataResp = new SfaVisitStepDefaultEsData(){{
                this.initAttachmentExt6();
            }};
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }else{
            SfaVisitStepDefaultEsData esData = this.getEsDataById(bizId);
            if(null == esData){
                throw new BusinessException("未查询到该数据详细信息!");
            }
            return esData;
        }

    }

    /**
     * 组装参数，可扩展
     * @param sfaVisitPlanInfoEntity
     * @param redisData
     */
    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepDefaultRedisData redisData){
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData(redisData);

        if(sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity){
            this.buildClientData(redisData, (SfaVisitPlanInfoEntity)sfaVisitPlanInfoEntity);
        }else {
            this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }
    }

    /**
     * 校验数据，可扩展
     * @param sfaVisitPlanInfoEntity
     * @param visitStepExecuteReq
     */
    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq){
        super.check(visitStepExecuteReq);

        SfaVisitStepDefaultEntity executeData = visitStepExecuteReq.getStepExecuteData();
        if(null == executeData){
            throw new BusinessException("执行数据为空");
        }
//        if(StringUtils.isBlank(storeCheckStepExecuteData.getCheckAddress())){
//            throw new BusinessException("定位地址信息为空");
//        }
//        if(StringUtils.isBlank(storeCheckStepExecuteData.getLongitude())){
//            throw new BusinessException("经度为空");
//        }
//        if(StringUtils.isBlank(storeCheckStepExecuteData.getLatitude())){
//            throw new BusinessException("纬度为空");
//        }
//        this.checkPics(storeCheckStepExecuteData.getRegularShelfDisplayList(), 1, 5, "常规货架陈列");
    }



}
