package com.biz.crm.moblie.controller.visit.req.step;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.nebular.mdm.ExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("拜访步骤-协访评价-执行数据请求VO")
public class HelpScoreStepExecuteData extends ExtTenVo implements VisitStepExecuteReq.StepExecuteDataReq {

    /**
     * 协防总结
     */
    @ApiModelProperty("协访总结")
    private String helpDefenseSummary;

    /**
     * 重点问题记录
     */
    @ApiModelProperty("重点问题记录")
    private String keyQuestions;

    @ApiModelProperty("附件容器1")
    private List<CrmAttachment> attachmentExt1;

    @ApiModelProperty("附件容器2")
    private List<CrmAttachment> attachmentExt2;

    @ApiModelProperty("评价明细")
    private List<HelpScoreDetailReqVo> helpScoreDetailList;


    /**
     * 评价明细
     *  @author: luoqi
     *  @Date: 2021-3-5 14:50
     *  @version: V1.0
     *  @Description:
     */
    @Data
    @ApiModel("拜访步骤-协访评价-执行数据请求VO-评价明细")
    public static class HelpScoreDetailReqVo extends ExtTenVo {
        @ApiModelProperty("步骤图标")
        private String icon;

        @ApiModelProperty("步骤编码")
        private String stepCode;

        @ApiModelProperty("步骤名称")
        private String stepName;

        @ApiModelProperty("合格/不合格")
        private String qualified;

        @ApiModelProperty("合格/不合格")
        private String qualifiedName;

        @ApiModelProperty("步骤评分")
        private BigDecimal score;

        @ApiModelProperty("排列顺序")
        private Integer sort;
    }
}
