package com.biz.crm.moblie.controller.visit.req.step;

import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.resp.DataConvert;
import com.biz.crm.nebular.mdm.ExtTenObjVo;
import com.biz.crm.nebular.mdm.ExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("拜访步骤-订单采集-执行数据请求VO")
public class OrderStepExecuteData<T extends OrderStepExecuteData.OrderItemReqVo> extends ExtTenObjVo implements VisitStepExecuteReq.StepExecuteDataReq, DataConvert {
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("订单来源")
    private String orderSource;

    @ApiModelProperty("上级客户编码")
    private String customerCode;

    @ApiModelProperty("上级客户名称")
    private String customerName;

    @ApiModelProperty("联系人")
    private String contacts;

    @ApiModelProperty("联系电话")
    private String telephone;

    @ApiModelProperty("收货地址")
    private String address;

    @ApiModelProperty("期望收货时间 yyyy-MM-dd")
    private String expectReceive;


    @ApiModelProperty("订单总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("备注")
    private String remarks;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 维度
     */
    @ApiModelProperty("维度")
    private String latitude;


    @ApiModelProperty("商品清单")
    private List<T> sfaVisitStepOrderItems;

    @Override
    public void convert() {
    }


    /**
     * 订单商品项
     *
     * @author: luoqi
     * @Date: 2021-3-5 14:50
     * @version: V1.0
     * @Description:
     */
    @Data
    @ApiModel("拜访步骤-订单采集-执行数据请求VO-订单商品项")
    public static class OrderItemReqVo extends ExtTenVo {

        @ApiModelProperty("产品图片")
        private String picUrl;

        @ApiModelProperty("产品编码")
        private String productCode;

        @ApiModelProperty("产品名称")
        private String productName;

        @ApiModelProperty("产品系列编码")
        private String seriesCode;

        @ApiModelProperty("产品系列名称")
        private String seriesName;

        @ApiModelProperty("数量")
        private BigDecimal quantity;

        @ApiModelProperty("单位")
        private String unit;

        @ApiModelProperty("单位名称")
        private String unitName;

        @ApiModelProperty("商品单价")
        private BigDecimal price;

        @ApiModelProperty("行类型(1-本品,2-赠品)")
        private String itmeType;
    }


}
