package com.biz.crm.moblie.controller.visit.req.step;

import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.nebular.mdm.ExtTenObjVo;
import com.biz.crm.nebular.mdm.ExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Mapping;

import java.util.List;

@Data
@ApiModel("拜访步骤-库存盘点-执行数据请求VO")
public class StockInventoryStepExecuteData extends ExtTenObjVo implements VisitStepExecuteReq.StepExecuteDataReq {

    /**
     * 盘库地址
     */
    @ApiModelProperty("地址")
    private String stockAddress;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 维度
     */
    @ApiModelProperty("维度")
    private String latitude;


    @ApiModelProperty("库存盘点明细")
    private List<StockDetailReqVo> visitStepStockList;


    /**
     * 库存盘点明细
     *  @author: luoqi
     *  @Date: 2021-3-5 14:50
     *  @version: V1.0
     *  @Description:
     */
    @Data
    @ApiModel("拜访步骤-库存盘点-执行数据请求VO-库存盘点明细")
    public static class StockDetailReqVo extends ExtTenVo {



        @ApiModelProperty("产品编码")
        private String productCode;

        @ApiModelProperty("产品名称")
        private String productName;

        @ApiModelProperty("系列编码")
        private String productLevelCode;

        @ApiModelProperty("系列名称")
        private String productLevelName;

        @ApiModelProperty("盘库时间")
        @Mapping(mappingPath = "es-mapping/date-time.json")
        private String stockTime;

        @ApiModelProperty("数量")
        private Integer quantity;

        @ApiModelProperty("单位")
        private String saleUnit;
        /**
         * 单位名称
         */
        @ApiModelProperty("单位名称")
        private String saleUnitName;
    }
}
