package com.biz.crm.moblie.controller.visit.resp.step;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityProductRespVo;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Data
@ApiModel("拜访步骤-陈列检查-查询表单执行数据")
public class ActivityDisplayStepExecuteDataResp extends ActivityStepExecuteDataResp implements StepExecuteDataResp {
    @ApiModelProperty("网点名称(终端名称)")
    private String clientName;

    @ApiModelProperty("活动执行频率(天)")
    private String activityFrequency;

    @ApiModelProperty("上次执行时间")
    private String lastActivityTime;


    @ApiModelProperty("陈列要求内容")
    private DisplayContent displayContent;

    @ApiModelProperty("活动执行明细状态")
    private String executeStatus;

    @ApiModelProperty("活动执行明细状态失败说明")
    private String executeMsg;

    /**
     * 陈列活动-陈列要求
     *  @author: luoqi
     *  @Date: 2021-3-5 14:50
     *  @version: V1.0
     *  @Description:
     */
    @Data
    @ApiModel("拜访-活动执行请求数据-活动执行要求内容")
    public static class DisplayContent{
        @ApiModelProperty("活动产品列表")
        private List<SfaActivityProductRespVo> activityProductList;


        @ApiModelProperty("陈列要求示例图片列表")
        private List<CrmAttachment> pictureList;
    }


}
