package com.biz.crm.moblie.controller.visit.resp.step;

import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.nebular.mdm.ExtTenObjVo;
import com.biz.crm.nebular.mdm.ExtTenVo;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

@Data
@ApiModel("拜访步骤-库存盘点-查看库存盘点明细信息")
public class StockInventoryStepInfoDataResp extends ExtTenObjVo implements StepExecuteDataResp {
    @ApiModelProperty("盘库时间")
    private String stockTime;

    @ApiModelProperty("操作人")
    private String userName;

    @ApiModelProperty("操作人姓名")
    private String realName;

    /**
     * 盘库地址
     */
    @ApiModelProperty("地址")
    private String stockAddress;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 维度
     */
    @ApiModelProperty("维度")
    private String latitude;



    @ApiModelProperty("系列数")
    private Integer productLevelNum = 0;

    @ApiModelProperty("商品种类数")
    private Integer productCodeNum = 0;

    @ApiModelProperty("商品数")
    private Integer productTotalNum = 0;



    @ApiModelProperty("明细分组")
    private List<StockDetailGroup> stockDetailGroups;

    @ApiModelProperty("表单配置")
    private SfaVisitStepFromRespVo sfaVisitStepFrom;

    @Data
    @ApiModel("拜访步骤-库存盘点-查看库存盘点明细信息-明细分组")
    public static class StockDetailGroup{
        @ApiModelProperty("系列编码")
        private String productLevelCode;

        @ApiModelProperty("系列名称")
        private String productLevelName;

        @ApiModelProperty("合计数量")
        private Integer total = 0;
        @ApiModelProperty("库存盘点明细")
        private List<StockInventoryStepExecuteData.StockDetailReqVo> visitStepStockList = Lists.newArrayList();
    }

    /**
     * 汇总计算盘点明细
     * @param visitStepStockList
     * @return
     */
    public List<StockDetailGroup> stockDetailGroupAndTotalNum(List<StockInventoryStepExecuteData.StockDetailReqVo> visitStepStockList){
        if(CollectionUtils.isEmpty(visitStepStockList)){
            return Lists.newArrayList();
        }
        Map<String, StockDetailGroup> map = Maps.newHashMap();
        for (StockInventoryStepExecuteData.StockDetailReqVo stockDetailReqVo : visitStepStockList) {
            StockDetailGroup group = map.get(stockDetailReqVo.getProductLevelCode());
            if(null == group){
                group = new StockDetailGroup();
                this.setProductLevelNum(this.getProductLevelNum() + 1);
            }
            Integer quantity = null == stockDetailReqVo.getQuantity() ? 0 : stockDetailReqVo.getQuantity();
            group.setProductLevelCode(stockDetailReqVo.getProductLevelCode());
            group.setProductLevelName(stockDetailReqVo.getProductLevelName());
            group.setTotal(group.getTotal() + quantity);
            group.getVisitStepStockList().add(stockDetailReqVo);
            map.put(group.getProductLevelCode(), group);
            this.setProductCodeNum(this.getProductCodeNum() + 1);
            this.setProductTotalNum(this.getProductTotalNum() + quantity);
        }
        List<StockDetailGroup> groups = Lists.newArrayList(map.values());
        this.setStockDetailGroups(groups);
        return groups;
    }
}
