package com.biz.crm.moblie.controller.workbench;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.SfaUnfamiliarTempPlanInfoReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitTempPlanReqVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitnote.req.SfaVisitTempPlanReq;
import com.biz.crm.visitnote.service.ISfaVisitTempPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 临时拜访计划制定
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitTempPlanController")
@Api(tags = "临时拜访计划制定 ")
public class SfaVisitTempPlanController {
    @Resource
    private ISfaVisitTempPlanService sfaVisitTempPlanService;


    @ApiOperation(value = "新增临时拜访计划-工作台")
    @PostMapping("/save")
    @CrmLog
    public Result addTempPlanInfoForWorkbench(@RequestBody SfaVisitTempPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
        sfaVisitPlanReqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R2.getVal());
        sfaVisitTempPlanService.addTempPlanInfoForWorkbench(sfaVisitPlanReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "新增临时拜访计划-附近客户")
    @PostMapping("/addTempPlanInfoForNearby")
    @CrmLog
    public Result<SfaVisitResp.SfaVisitPlanInfoResp> addTempPlanInfoForNearby(@RequestBody SfaVisitTempPlanReq sfaVisitTempPlanReq) {
        SfaVisitResp.SfaVisitPlanInfoResp planInfoResp = sfaVisitTempPlanService.addTempPlanInfoForNearby(sfaVisitTempPlanReq);
        Result result = Result.ok();
        result.setResult(planInfoResp);
        return result;
    }

    @ApiOperation(value = "新增临时拜访计划-陌拜")
    @PostMapping("/addTempPlanInfoForUnfamiliar")
    @CrmLog
    public Result<SfaVisitResp.SfaVisitPlanInfoResp> addTempPlanInfoForUnfamiliar(@RequestBody SfaUnfamiliarTempPlanInfoReq sfaUnfamiliarTempPlanInfoReq) {
        SfaVisitResp.SfaVisitPlanInfoResp planInfoResp = sfaVisitTempPlanService.addTempPlanInfoForUnfamiliar(sfaUnfamiliarTempPlanInfoReq);
        Result result = Result.ok();
        result.setResult(planInfoResp);
        return result;
    }


    @ApiOperation(value = "今日拜访数")
    @GetMapping("/getVisitNum")
    @CrmLog
    public Result<Integer> getVisitNum(@RequestParam(value = "dateFlag" ,required = false) String dateFlag) {
        return Result.ok(sfaVisitTempPlanService.getVisitNum(dateFlag));
    }

}
