package com.biz.crm.moblie.controller.workbench;

import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.actscheme.service.ISfaActSchemePosApplyService;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.impl.*;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.step.*;
import com.biz.crm.moblie.controller.workbench.req.CompetitorWorkbenchDataReq;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.moblie.controller.workbench.req.StockInventoryWorkbenchDataReq;
import com.biz.crm.moblie.controller.workbench.req.StoreCheckWorkbenchDataReq;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmActOrderCollectVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectFormVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.CashTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.GoodsTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.SfaTpmActTreatyRedisVo;
import com.biz.crm.nebular.sfa.tpmact.distributionorder.DistributionOrderVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailProductReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReportReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActReportRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStoreCheckReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletReportRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStoreCheckRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.SfaVisitStepStockVo;
import com.biz.crm.nebular.sfa.visitstepdetail.req.SfaVisitStepStockInventoryReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaStockInventoryRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.tpmact.service.ISfaVisitStepTpmActCollectService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.req.*;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceEsImpl;
import com.biz.crm.visitstep.service.impl.SfaVisitStepColletServiceEsImpl;
import com.biz.crm.visitstep.service.impl.SfaVisitStepOrderServiceEsImpl;
import com.biz.crm.visitstep.service.impl.SfaVisitStepStoreCheckServiceEsImpl;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import com.biz.crm.visitstepdetail.service.impl.SfaVisitStepStockInventoryServiceEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lf
 * @describe 计算薪资日期日志表实体类
 * @project crm
 * @package com.biz.crm.moblie.controller
 * @date 2020/12/29 22:47
 */
@Slf4j
@RestController
@RequestMapping("sfaWorkDailyController")
@Api(tags = "小程序端-工作台-日常工作")
public class SfaWorkDailyController {

    @Resource
    private ISfaVisitStepStockInventoryService sfaVisitStepStockInventoryService;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private SfaVisitStepActivityExecutionServiceEsImpl sfaVisitStepActivityExecutionServiceEsImpl;
    @Resource
    private ISfaActSchemePosApplyService sfaActSchemePosApplyService;
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private SfaVisitStepColletServiceEsImpl sfaVisitStepColletServiceEsImpl;
    @Resource
    private SfaVisitStepStoreCheckServiceEsImpl sfaVisitStepStoreCheckServiceEsImpl;
    @Resource
    private SfaVisitStepOrderServiceEsImpl sfaVisitStepOrderServiceEsImpl;
    @Resource
    private SfaVisitStepStockInventoryServiceEsImpl sfaVisitStepStockInventoryServiceEsImpl;
    @Resource
    private StoreCheckVisitStepExecutor storeCheckVisitStepExecutor;
    @Resource
    private OrderVisitStepExecutor orderVisitStepExecutor;
    @Resource
    private StockInventoryVisitStepExecutor stockInventoryVisitStepExecutor;
    @Resource
    private CompetitorVisitStepExecutor competitorVisitStepExecutor;
    @Resource
    private DefaultVisitStepExecutor defaultVisitStepExecutor;
    @Resource
    private ActivityCostVisitStepExecutor activityCostVisitStepExecutor;
    @Resource
    private ActivityDisplayVisitStepExecutor activityDisplayVisitStepExecutor;
    @Autowired
    private ISfaTpmActDetailService sfaTpmActDetailService;
    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;
    @Autowired
    private ISfaVisitStepTpmActCollectService sfaVisitStepTpmActCollectService;


    /**
     * 工作台-竞品采集
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation("工作台-竞品采集")
    @PostMapping("executeForWorkbenchCompetitor")
    @CrmLog
    public Result executeForWorkbenchCompetitor(@RequestBody VisitStepExecuteReq<CompetitorWorkbenchDataReq> visitStepExecuteReq) {
        this.competitorVisitStepExecutor.executeForWorkbench(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 工作台-竞品采集
     *
     * @param req
     * @return
     */
    @ApiOperation("工作台-查询竞品采集列表")
    @PostMapping("getWorkbenchCompetitorPage")
    @CrmLog
    public Result<PageResult<SfaVisitStepColletReportRespVo>> getWorkbenchCompetitorPage(@RequestBody GetColletPageReq req) {

        return Result.ok(this.sfaVisitStepColletServiceEsImpl.getWorkbenchCompetitorPage(req));
    }

    /**
     * 加载工作台编辑页面数据
     *
     * @param loadParam
     * @return
     */
    @CrmLog
    @PostMapping("loadEditPageForWorkbenchCompetitor")
    @ApiOperation("工作台-查询竞品采集详细信息")
    public Result<CompetitorStepExecuteDataResp> loadEditPageForWorkbenchCompetitor(@RequestBody ExecutorWorkbenchLoadReq loadParam) {
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp) competitorVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        return Result.ok(dataResp);
    }


    /**
     * 工作台-库存盘点
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation("工作台-库存盘点")
    @PostMapping("executeForWorkbenchStockInventory")
    @CrmLog
    public Result executeForWorkbenchStockInventory(@RequestBody VisitStepExecuteReq<StockInventoryWorkbenchDataReq> visitStepExecuteReq) {
        this.stockInventoryVisitStepExecutor.executeForWorkbench(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 工作台-库存盘点
     *
     * @param sfaVisitStepStockVo
     * @return
     */
    @ApiOperation("工作台-库存盘点")
    @PostMapping("saveWorkStock")
    @Deprecated
    @CrmAPIDiscard
    @CrmLog
    public Result saveWorkStock(@RequestBody SfaVisitStepStockVo sfaVisitStepStockVo) {
//        sfaVisitStepStockInventoryService.saveWorkStockList(sfaVisitStepStockVo);
        return Result.ok();
    }

    /**
     * 工作台-查询库存盘点信息列表
     */
    @ApiOperation(value = "工作台-查询库存盘点信息列表")
    @PostMapping("/getWorkbenchStockInventoryPage")
    @CrmLog
    public Result<PageResult<SfaVisitStepStockInventoryRespVo>> getWorkbenchStockInventoryPage(@RequestBody GetStockInventoryPageReq req) {
        PageResult<SfaVisitStepStockInventoryRespVo> result = sfaVisitStepStockInventoryServiceEsImpl.getWorkbenchStockInventoryPage(req);
        return Result.ok(result);
    }

    /**
     * 工作台-查询库存盘点信息列表
     */
    @ApiOperation(value = "工作台-查询库存盘点信息列表")
    @PostMapping("/findWorkStockList")
    @Deprecated
    @CrmAPIDiscard
    @CrmLog
    public Result<PageResult<SfaVisitStepStockInventoryRespVo>> findWorkStockList(@RequestBody SfaVisitStepStockInventoryReqVo sfaVisitStepStockInventoryReqVo) {
//        PageResult<SfaVisitStepStockInventoryRespVo> result=sfaVisitStepStockInventoryService.findWorkStockList(sfaVisitStepStockInventoryReqVo);
        return null;
    }

    /**
     * 加载库存盘点编辑页面
     *
     * @param loadParam
     * @return
     */
    @CrmLog
    @PostMapping("loadEditPageForWorkbenchStockInventory")
    @ApiOperation(value = "工作台-加载库存盘点编辑页面")
    public Result<StockInventoryStepExecuteDataResp> loadEditPageForWorkbenchStockInventory(@RequestBody ExecutorWorkbenchLoadReq loadParam) {
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp) stockInventoryVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        return Result.ok(dataResp);
    }

    /**
     * 查看库存盘点明细信息
     *
     * @param loadParam
     * @return
     */
    @CrmLog
    @PostMapping("loadInfoPageForWorkbenchStockInventory")
    @ApiOperation(value = "工作台-查看库存盘点明细信息")
    public Result<StockInventoryStepInfoDataResp> loadInfoPageForWorkbenchStockInventory(@RequestBody ExecutorWorkbenchLoadReq loadParam) {
        return Result.ok(sfaVisitStepStockInventoryService.loadInfoPage(loadParam));
    }

    /**
     * 查询库存盘点明细信息
     *
     * @param id
     * @return
     */
    @CrmLog
    @GetMapping("queryStockInventoryDetail")
    @Deprecated
    @CrmAPIDiscard
    @ApiOperation(value = "工作台-查询库存盘点明细信息")
    public Result<SfaStockInventoryRespVo> queryStockInventoryDetail(@RequestParam String id) {
//        SfaStockInventoryRespVo sfaStockInventoryRespVo = sfaVisitStepStockInventoryService.queryStockInventoryDetail(id);
        return null;
    }


    /**
     * 工作台-订单采集_新增修改
     * 新增只存在于订单采集
     * 修改 不改变订单的来源（orderSource）
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "工作台-订单采集——新增修改")
    @PostMapping("/executeForWorkbenchOrder")
    @CrmLog
    public Result executeForWorkbenchOrder(@RequestBody VisitStepExecuteReq<OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo>> visitStepExecuteReq) {
        orderVisitStepExecutor.executeForWorkbench(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 工作台-订单采集-方案活动
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "方案活动执行测试-订单推送")
    @PostMapping("/executeForAs")
    @CrmLog
    public Result executeForAs(@RequestBody OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo> visitStepExecuteReq) {
        orderVisitStepExecutor.executeForAs(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 工作台-订单采集
     *
     * @param orderReqVo
     * @return
     */
    @ApiOperation(value = "工作台-订单采集")
    @PostMapping("/saveWorkOrder")
    @Deprecated
    @CrmAPIDiscard
    @CrmLog
    public Result saveWorkOrder(@RequestBody SfaVisitStepOrderReqVo orderReqVo) {
//        sfaVisitStepOrderService.save(orderReqVo);
        return Result.ok();
    }

    /**
     * 查询工作台订单采集列表
     */
    @ApiOperation(value = "工作台-查询订单采集列表")
    @PostMapping("/getWorkbenchOrderPage")
    @CrmLog
    public Result<PageResult<SfaVisitStepOrderRespVo>> getWorkbenchOrderPage(@RequestBody GetOrderPageReq req) {
        //该接口不使用
//        PageResult<SfaVisitStepOrderRespVo> result = sfaVisitStepOrderServiceEsImpl.getWorkbenchOrderPage(req);
        PageResult<SfaVisitStepOrderRespVo> result = sfaVisitStepOrderService.getWorkbenchOrderPage(req);
        return Result.ok(result);
    }

    /**
     * 查询工作台订单采集列表
     */
    @ApiOperation(value = "工作台-查询订单采集列表")
    @PostMapping("/findWorkOrderList")
    @Deprecated
    @CrmAPIDiscard
    @CrmLog
    public Result<PageResult<SfaVisitStepOrderRespVo>> findWorkOrderList(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
//        PageResult<SfaVisitStepOrderRespVo> result=sfaVisitStepOrderService.findWorkOrderList(sfaVisitStepOrderReqVo);
        return null;
    }

    /**
     * 工作台-查询订单采集详细信息
     *
     * @param loadParam
     * @return
     */
    @CrmLog
    @PostMapping("loadEditPageForWorkbenchOrder")
    @ApiOperation(value = "工作台-查询订单采集详细信息")
    public Result<OrderStepExecuteDataResp> loadEditPageForWorkbenchOrder(@RequestBody ExecutorWorkbenchLoadReq loadParam) {
        OrderStepExecuteDataResp orderStepExecuteDataResp = (OrderStepExecuteDataResp) orderVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        return Result.ok(orderStepExecuteDataResp);
    }

    /**
     * 工作台-查询订单采集详细信息
     *
     * @param id
     * @return
     */
    @CrmLog
    @GetMapping("queryOrderDetail")
    @Deprecated
    @CrmAPIDiscard
    @ApiOperation(value = "工作台-查询订单采集详细信息")
    public Result<SfaVisitStepOrderRespVo> queryOrderDetail(@RequestParam String id) {
//        SfaVisitStepOrderRespVo sfaVisitStepOrderRespVo = sfaVisitStepOrderService.queryOrderDetail(id);
        return null;
    }

    /**
     * 订单采集，审批驳回，追回修改
     *
     * @param sfaVisitStepOrderReqVo
     * @return
     */
    @CrmLog
    @PostMapping("updateOrder")
    @Deprecated
    @CrmAPIDiscard
    @ApiOperation(value = "订单采集，审批驳回，追回修改")
    public Result updateOrder(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
//         sfaVisitStepOrderService.updateOrder(sfaVisitStepOrderReqVo);
        return Result.ok();
    }

    /**
     * 订单采集审批状态修改——审批流回调方法
     *
     * @param activitiCallBackVo
     * @return
     */
    @CrmLog
    @PostMapping("updateOrderApprovalStatus")
    @ApiOperation(value = "订单采集审批状态修改——审批流回调方法（前端勿用")
    public Result updateOrderApprovalStatus(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        orderVisitStepExecutor.updateOrderApprovalStatus(activitiCallBackVo);
        return Result.ok();
    }

    /**
     * 订单采集追回
     *
     * @param sfaVisitStepOrderReqVo
     * @return
     */
    @CrmLog
    @PostMapping("recoverApproval")
    @Deprecated
    @CrmAPIDiscard
    @ApiOperation(value = "订单采集追回")
    public Result recoverApproval(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
//        return sfaVisitStepOrderService.recoverApproval(sfaVisitStepOrderReqVo);
        return null;
    }


    /**
     * 工作台-店面检查
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "工作台-店面检查")
    @PostMapping("/executeForWorkbenchStoreCheck")
    @CrmLog
    public Result executeForWorkbenchStoreCheck(@RequestBody VisitStepExecuteReq<StoreCheckWorkbenchDataReq> visitStepExecuteReq) {
        this.storeCheckVisitStepExecutor.executeForWorkbench(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 工作台-店面检查
     *
     * @param storeCheckReqVo
     * @return
     */
    @ApiOperation(value = "工作台-店面检查")
    @PostMapping("/saveWorkStoreCheck")
    @Deprecated
    @CrmAPIDiscard
    @CrmLog
    public Result saveWorkStoreCheck(@RequestBody SfaVisitStepStoreCheckReqVo storeCheckReqVo) {
//        sfaVisitStepStoreCheckService.save(storeCheckReqVo);
        return Result.ok();
    }

    /**
     * 列表
     */
    @ApiOperation(value = "工作台-查询店面检查列表")
    @PostMapping("/getWorkbenchStoreCheckPage")
    @CrmLog
    public Result<PageResult<SfaVisitStepStoreCheckRespVo>> getWorkbenchStoreCheckPage(@RequestBody GetStoreCheckPageReq req) {
        PageResult<SfaVisitStepStoreCheckRespVo> result = sfaVisitStepStoreCheckServiceEsImpl.getWorkbenchStoreCheckPage(req);
        return Result.ok(result);
    }

    /**
     * 列表
     */
    @ApiOperation(value = "工作台-查询店面检查列表")
    @PostMapping("/findWorkDailyStoreCheckList")
    @Deprecated
    @CrmAPIDiscard
    @CrmLog
    public Result<PageResult<SfaVisitStepStoreCheckRespVo>> findWorkDailyStoreCheckList(@RequestBody SfaVisitStepStoreCheckReqVo sfaVisitStepStoreCheckReqVo) {
//        PageResult<SfaVisitStepStoreCheckRespVo> result=sfaVisitStepStoreCheckService.findWorkDailyStoreCheckList(sfaVisitStepStoreCheckReqVo);
        return null;
    }

    /**
     * 工作台-查询店面检查详细信息
     *
     * @param loadParam
     * @return
     */
    @CrmLog
    @PostMapping("loadEditPageForWorkbenchStoreCheck")
    @ApiOperation(value = "工作台-查询店面检查详细信息")
    public Result<StoreCheckStepExecuteDataResp> loadEditPageForWorkbenchStoreCheck(@RequestBody ExecutorWorkbenchLoadReq loadParam) {
        StoreCheckStepExecuteDataResp respVo = (StoreCheckStepExecuteDataResp) storeCheckVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        return Result.ok(respVo);
    }

    /**
     * 工作台-查询店面检查详细信息
     *
     * @param id
     * @return
     */
    @CrmLog
    @GetMapping("queryWorkStoreCheckDetail")
    @Deprecated
    @CrmAPIDiscard
    @ApiOperation(value = "工作台-查询店面检查详细信息")
    public Result<SfaVisitStepStoreCheckRespVo> queryWorkStoreCheckDetail(@RequestParam String id) {
//        SfaVisitStepStoreCheckRespVo respVo = sfaVisitStepStoreCheckService.queryWorkStoreCheckDetail(id);
        return null;
    }


    /**
     * 工作台-活动执行(陈列，费用活动执行)
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "工作台-活动执行(陈列，费用活动执行)")
    @PostMapping("/saveVisitActivityExecutionForWorkbench")
    @CrmLog
    public Result saveVisitActivityExecutionForWorkbench(@RequestBody VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq) {
        ActivityStepExecuteData dataReq = visitStepExecuteReq.getStepExecuteData();
        if (null == dataReq) {
            throw new BusinessException("请求参数执行数据对象为空");
        }
        if (StringUtils.isBlank(dataReq.getId())) {
            throw new BusinessException("活动执行明细ID为空");
        }
        SfaVisitStepActivityExecutionEntity executionEntity = this.sfaVisitStepActivityExecutionService.getById(visitStepExecuteReq.getStepExecuteData().getId());
        if (null == executionEntity) {
            throw new BusinessException("未查询到活动执行明细");
        }
        if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(executionEntity.getActivityType())) {
            this.activityDisplayVisitStepExecutor.executeForWorkbench(visitStepExecuteReq);
        } else {
            this.activityCostVisitStepExecutor.executeForWorkbench(visitStepExecuteReq);
        }
        return Result.ok();
    }


    /**
     * 工作台-查询可执行活动列表
     *
     * @return
     */
    @CrmLog
    @PostMapping("getActForWorkbench")
    @ApiOperation(value = "工作台-查询可执行活动列表")
    public Result<PageResult<SfaActivityExecutionEntityResp>> getActForWorkbench(@RequestBody GetActForWorkbenchReq reqVo) {
        PageResult<SfaActivityExecutionEntityResp> result = sfaVisitStepActivityExecutionService.getActForWorkbench(reqVo);
        return Result.ok(result);
    }

    /**
     * 查询活动执行列表-待执行
     *
     * @return
     */
    @CrmLog
    @PostMapping("findReadyActivityExecution")
    @ApiOperation(value = "查询方案活动执行列表-待执行")
    public Result<PageResult<SfaActivityExecutionRespVo>> findReadyActivityExecution(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        PageResult<SfaActivityExecutionRespVo> pageResult;
        AssertUtils.isNotEmpty(reqVo.getActivityType(), "活动类型为空");
        reqVo.setDoNot(SfaCommonEnum.whether.YES.getValue());
        if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.SCHEME_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.SCHEME_ACTIVITY.getVal());
            pageResult = sfaActSchemePosApplyService.findActSchemeList(reqVo);
        } else {
            pageResult = new PageResult<>();
            pageResult.setCount(0L);
        }
        return Result.ok(pageResult);
    }


    /**
     * 查询工作台活动执行完成列表
     */
    @ApiOperation(value = "查询工作台活动执行完成列表")
    @PostMapping("/findWorkCompleteActivityExecutionList")
    @CrmLog
    public Result<PageResult<SfaVisitStepActivityExecutionRespVo>> findWorkCompleteActivityExecutionList(@RequestBody GetCompleteActivityPageReq req) {
        PageResult<SfaVisitStepActivityExecutionRespVo> pageResult = new PageResult<SfaVisitStepActivityExecutionRespVo>();
        String activityType = req.getActivityType();
        AssertUtils.isNotEmpty(activityType, "活动类型为空");
        if (activityType.equals(SfaActivityEnum.activityType.COST_ACTIVITY.getVal())
                || activityType.equals(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())) {
            pageResult = sfaVisitStepActivityExecutionServiceEsImpl.getCompleteActivityPage(req);
        } else if (activityType.equals(SfaActivityEnum.activityType.SCHEME_ACTIVITY.getVal())) {
            SfaVisitStepActivityExecutionReqVo reqVo = CrmBeanUtil.copy(req, SfaVisitStepActivityExecutionReqVo.class);
            pageResult = sfaActSchemePosApplyService.findActSchemeCompleteList(reqVo);
        }
        return Result.ok(pageResult);
    }

    /**
     * 加载工作台活动执行编辑页面数据
     *
     * @param loadParam
     * @return
     */
    @CrmLog
    @PostMapping("loadActExecutionEditPageForWorkbench")
    @ApiOperation(value = "工作台-加载工作台活动执行编辑页面数据")
    public Result<ActivityStepExecuteDataResp> loadActExecutionEditPageForWorkbench(@RequestBody ExecutorWorkbenchLoadReq loadParam) {
        if (org.apache.commons.lang3.StringUtils.isBlank(loadParam.getBizId())) {
            throw new BusinessException("活动执行明细ID为空");
        }
        SfaVisitStepActivityExecutionEntity executionEntity = this.sfaVisitStepActivityExecutionService.getById(loadParam.getBizId());
        if (null == executionEntity) {
            throw new BusinessException("未查询到活动执行明细");
        }
        if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(executionEntity.getActivityType())) {
            ActivityDisplayStepExecuteDataResp dataResp = (ActivityDisplayStepExecuteDataResp) activityDisplayVisitStepExecutor.loadEditPageForWorkbench(loadParam);
            dataResp.setExecuteMsg(executionEntity.getExecuteMsg());
            dataResp.setExecuteStatus(executionEntity.getExecuteStatus());
            return Result.ok(dataResp);
        }
        ActivityCostStepExecuteDataResp dataResp = (ActivityCostStepExecuteDataResp) activityCostVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        return Result.ok(dataResp);
    }

    /**
     * 通过活动执行id查询详情
     *
     * @param id
     * @return
     */
    @CrmLog
    @GetMapping("queryDetailById")
    @Deprecated
    @ApiOperation(value = "工作台-查询活动执行详情")
    public Result<SfaActivityExecutionRespVo> queryDetailById(@RequestParam String id) {
        return Result.ok(sfaVisitStepActivityExecutionService.queryDetailById(id));
    }


    /**
     * 通过id查询详情
     */
    @ApiOperation(value = "工作台-查询待执行活动详情")
    @GetMapping("/queryReadyDetailById")
    @Deprecated
    @CrmLog
    public Result<SfaActivityExecutionRespVo> queryReadyDetailById(@RequestParam String id) {
        SfaActivityExecutionRespVo respVo = sfaActivityExecutionService.queryDetailById(id);
        return Result.ok(respVo);
    }


    /**
     * 查询终端供货经销商
     *
     * @param terminalCode
     * @return
     */
    @CrmLog
    @GetMapping("findTerminalSupplyList")
    @ApiOperation(value = "查询终端供货经销商")
    public Result<List<MdmTerminalSupplyVo>> findTerminalSupplyList(@RequestParam String terminalCode) {
        List<MdmTerminalSupplyVo> mdmTerminalSupplyVos = sfaVisitStepOrderService.findTerminalSupplyList(terminalCode);
        return Result.ok(mdmTerminalSupplyVos);
    }

    /**
     * 获取今日订单数
     *
     * @return
     */
    @CrmLog
    @GetMapping("getOrderNum")
    @ApiOperation(value = "获取订单数")
    public Result<Integer> getOrderNum(@RequestParam(value = "dateFlag", required = false) String dateFlag) {
        return Result.ok(sfaVisitStepOrderService.getOrderNum(dateFlag));
    }

    /**
     * 根据id获取审批详情
     */
    @CrmLog
    @PostMapping("findSfaOrderById")
    @CrmAPIDiscard
    @ApiOperation(value = "根据id获取审批详情")
    public Result<List<OptRecordRspVO>> findSfaOrderById(@RequestBody String id) {

//        return Result.ok(sfaVisitStepOrderService.findSfaOrderById(id));
        return null;
    }


    @PostMapping("getTpmActList")
    @CrmLog
    @ApiOperation(value = "tpm活动-查询tpm活动列表(工作台/拜访执行共用接口)")
    public Result<PageResult<SfaTpmActRespVo>> getTpmActList(@RequestBody SfaTpmActReqVo tpmActReqVo) {
        return Result.ok(sfaTpmActDetailService.getTpmActList(tpmActReqVo));
    }

    @CrmLog
    @ApiOperation(value = "tpm活动-通过活动明细编码获得活动详情信息(工作台/拜访执行共用接口)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "actDetailCode", value = "活动明细编码", required = true, dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "redisHashKey", value = "工作台不传,拜访执行中必传", required = false, dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "visitPlanInfoId", value = "工作台不传,拜访完成详情查看必传", required = false, dataType = "string", paramType = "query")
    })
    @GetMapping("getTpmActDetailByActDetailCode")
    public Result<SfaTpmActDetailRespVo> getTpmActDetailByActDetailCode(@RequestParam(value = "actDetailCode") String actDetailCode,
                                                                        @RequestParam(value = "terminalCode") String terminalCode,
                                                                        @RequestParam(value = "redisHashKey", required = false) String redisHasKey,
                                                                        @RequestParam(value = "visitPlanInfoId", required = false) String visitPlanInfoId) {
        return Result.ok(sfaTpmActDetailService.getTpmActDetailByActDetailCode(actDetailCode, terminalCode, redisHasKey, visitPlanInfoId));
    }


    @GetMapping("findActCollectDataForm")
    @CrmLog
    @ApiOperation(value = "tpm活动-查询活动采集动态表单数据(工作台/拜访执行共用接口)")
    public Result<List<SfaTpmActCollectFormVo>> findActCollectDataForm(@RequestParam String fineCode, @RequestParam String actDetailCode) {
        List<SfaTpmActCollectFormVo> formVos = sfaTpmActDetailService.findActCollectDataForm(fineCode, actDetailCode);
        return Result.ok(formVos);
    }


    @CrmLog
    @ApiOperation(value = "tpm活动-查询活动商品(工作台/拜访执行共用接口)")
    @PostMapping("findActProductList")
    public Result<PageResult<SfaTpmActDetailProductRespVo>> findActProductList(@RequestBody SfaTpmActDetailProductReqVo reqVo) {
        return Result.ok(sfaTpmActDetailService.findActProductList(reqVo));
    }


    @CrmLog
    @PostMapping("saveWorkBenchGoodsTreaty")
    @ApiOperation(value = "tpm活动-陈列协议-货品协议保存")
    public Result<String> saveWorkBenchGoodsTreaty(@RequestBody GoodsTreatyVo vo) {
        Result result = new Result();
        String id = sfaAsTreatyService.saveWorkBenchGoodsTreaty(vo);
        result.setResult(id);
        return result;
    }

    @CrmLog
    @PostMapping("saveWorkBenchCashTreaty")
    @ApiOperation(value = "tpm活动-陈列协议-现金协议保存")
    public Result<String> saveWorkBenchCashTreaty(@RequestBody CashTreatyVo vo) {
        Result result = new Result();
        String id = sfaAsTreatyService.saveWorkBenchCashTreaty(vo);
        result.setResult(id);
        return result;
    }

    @CrmLog
    @ApiOperation(value = "tpm活动-陈列协议-获取详细信息(工作台/拜访执行共用接口)")
    @GetMapping("loadTpmActTreatyDetail")
    public Result<String> loadTpmActTreatyDetail(@RequestParam String id) {
        Result result = new Result();
        result.setResult(sfaAsTreatyService.loadTpmActTreatyDetail(id));
        return result;
    }


    @CrmLog
    @PostMapping("saveWorkBenchDistributionOrder")
    @ApiOperation(value = "tpm活动-分销订单采集保存")
    @Deprecated
    public Result<String> saveWorkBenchDistributionOrder(@RequestBody DistributionOrderVo vo) {
        Result result = new Result();
        String id = sfaVisitStepOrderService.saveWorkBenchDistributionOrder(vo);
        result.setResult(id);
        return result;
    }


    @CrmLog
    @GetMapping("loadTpmActDistributionOrderDetail")
    @ApiOperation(value = "tpm活动-分销订单-获取详细信息(工作台/拜访执行共用接口)")
    public Result<DistributionOrderVo> loadTpmActDistributionOrderDetail(@RequestParam String id,
                                                                         @RequestParam(name = "actDetailCode", required = false) String actDetailCode) {
        return Result.ok(sfaVisitStepOrderService.loadTpmActDistributionOrderDetail(id, actDetailCode));
    }

    @CrmLog
    @ApiOperation(value = "tpm活动-活动数据采集")
    @PostMapping("saveWorkBenchActCollect")
    @Deprecated
    public Result<String> saveWorkBenchActCollect(@RequestBody SfaTpmActCollectVo vo) {
        Result result = new Result();
        String id = sfaVisitStepTpmActCollectService.saveWorkBenchActCollect(vo);
        result.setResult(id);
        return result;
    }


    @CrmLog
    @ApiOperation(value = "tpm活动-分销订单、活动数据采集保存")
    @PostMapping("saveWorkBenchActOrderCollect")
    public Result saveWorkBenchActOrderCollect(@RequestBody SfaTpmActOrderCollectVo vo) {
        sfaVisitStepTpmActCollectService.saveWorkBenchActOrderCollect(vo);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "tpm活动-活动数据采集-获取详情信息(工作台/拜访执行共用接口)")
    @GetMapping("loadTpmActCollectDetail")
    public Result<SfaTpmActCollectVo> loadTpmActCollectDetail(@RequestParam String id) {
        return Result.ok(sfaVisitStepTpmActCollectService.loadTpmActCollectDetail(id));
    }


    @CrmLog
    @ApiOperation(value = "tpm活动-根据活动明细编码查询活动执行数据")
    @GetMapping("getTpmActExecuteDataByActDetailCode")
    public Result<List<SfaTpmActCollectVo>> getTpmActExecuteDataByActDetailCode(@RequestParam String actDetailCode) {
        return Result.ok(sfaVisitStepTpmActCollectService.getTpmActExecuteDataByActDetailCode(actDetailCode));
    }

    @CrmLog
    @ApiOperation(value = "tpm活动-查询拜访步骤明细报表tpm活动列表信息")
    @PostMapping("loadVisitStepTpmReport")
    public Result<List<SfaTpmActRespVo>> loadVisitStepTpmReport(@RequestBody SfaTpmActReportReqVo reqVo) {
        return Result.ok(sfaTpmActDetailService.loadVisitStepTpmReport(reqVo));
    }

    @CrmLog
    @ApiOperation(value = "tpm活动-查询拜访步骤明细报表tpm活动列表信息-查询活动明细")
    @PostMapping("getTpmActDetailReport")
    public Result<SfaTpmActReportRespVo> getTpmActDetailReport(@RequestBody SfaTpmActReportReqVo reqVo) {
        return Result.ok(sfaTpmActDetailService.getTpmActDetailReport(reqVo));
    }


}
