package com.biz.crm.moblie.controller.workbench;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.cache.util.WorkUtil;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.freesignconfig.service.ISfaFreesignConfigService;
import com.biz.crm.moblie.controller.workbench.resp.SfaNoticeRespVo;
import com.biz.crm.nebular.sfa.worksign.req.*;
import com.biz.crm.nebular.sfa.worksign.resp.*;
import com.biz.crm.util.*;
import com.biz.crm.worksign.model.NeedClock;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考情管理接口
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@RestController
@RequestMapping("/worksignrule")
@Api(tags = "小程序端-工作台页面-考勤管理 ")
public class SfaWorkSignController {
    @Autowired
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Autowired
    private ISfaWorkSignRecordService sfaWorkSignRecordService;
    @Autowired
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Autowired
    private ISfaFreesignConfigService sfaFreesignConfigService;
    @Autowired
    private ISfaLeaveService iSfaLeaveService;
    @Autowired
    ISfaLeaveCancelService iSfaLeaveCancelService;
    @Autowired
    private ISfaTravelService iSfaTravelService;
    @Autowired
    private WorkUtil workUtil;


//    @ApiOperation(value = "考勤历史-废弃")
//    @PostMapping("/findWorkSignInfoList")
//    @CrmAPIDiscard
//    @CrmLog
//    public PageResult<SfaWorkSignInfoRespVo> findWorkSignInfoList(@RequestBody SfaWorkSignInfoReqVo sfaWorkSignInfoReqVo) {
//        PageResult<SfaWorkSignInfoRespVo> result = new PageResult<>();
//        //获取当前登录人信息
//        UserRedis userRedis = UserUtils.getUser();
//        if (null!=userRedis && StringUtil.isNotEmpty(userRedis.getUsername())){
//            sfaWorkSignInfoReqVo.setUserName(userRedis.getUsername());
//            result = sfaWorkSignRuleInfoService.findWorkSignInfoList(sfaWorkSignInfoReqVo);
//        }
//        return result;
//    }
    @ApiOperation(value = "工作台页面——统一气泡接口")
    @PostMapping("/getAllNotice")
    @CrmLog
    public Result<SfaNoticeRespVo> getAllNotice() {
        UserRedis userRedis = UserUtils.getUser();
        return Result.ok(workUtil.getObj(userRedis.getPoscode()));
    }




    @ApiOperation(value = "查询当前登录人当前时间上班签到")
    @PostMapping("/fingGotoWorkClockIn")
    @CrmLog
    @CrmDictMethod
    public Result<SfaWorkSignRecordRespVo> fingGotoWorkClockIn() {
        return Result.ok(sfaWorkSignRuleInfoService.findSignRecordByNow(SfaWorkSignEnum.WorkSignType.CLOCK_IN));
    }

    /**
     * 查询当前地点当前登录人是否地点异常
     * @method getPlaceStatus
     * @date: 2021/4/12 9:47
     * @author: YuanZiJian
     */
    @ApiOperation(value = "查询当前地点当前登录人是否地点异常")
    @PostMapping("/getPlaceStatus")
    @CrmLog
    public Result getPlaceStatus(@RequestBody  ClockReqVo clockReqVo) {
        return sfaWorkSignRecordService.getPlaceStatus(clockReqVo);
    }

    @ApiOperation(value = "查询当前时间之前，打卡时是否有其他时间段的打卡明细。")
    @GetMapping("/getOtherTimeRecordInfo")
    @CrmLog
    @ApiImplicitParams({
            @ApiImplicitParam(name = "workSignType", value = "查询的打卡类型", required = true, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "id", value = "当前的打卡id不能为空", required = true, dataType = "String", paramType = "query")
    })
    public Result getOtherTimeRecordInfo(@RequestParam(value = "workSignType",required = false)  String workSignType , @RequestParam(value = "id",required = false)   String id  ) {
        return Result.ok(sfaWorkSignRecordService.getOtherTimeRecordInfo(workSignType,id));
    }

    /**
     * 查询当前登录人 当前时间下班签退
     * @return
     */
    @ApiOperation(value = "查询当前登录人当前时间下班签退")
    @PostMapping("/fingGooffWorkSignOut")
    @CrmLog
    @CrmDictMethod
    public Result<SfaWorkSignRecordRespVo> fingGooffWorkSignOut(){
        return Result.ok(sfaWorkSignRuleInfoService.findSignRecordByNow(SfaWorkSignEnum.WorkSignType.CLOCK_OUT));
    }

    /**
     * 打卡接口
     * @param clockReqVo
     * @return
     */
    @ApiOperation(value = "打卡接口")
    @PostMapping("/gotoWorkClock")
    @CrmLog
    public Result gotoWorkClock(@RequestBody ClockReqVo clockReqVo){
        Result result = sfaWorkSignRecordService.gotoWorkClock(clockReqVo);
        return result;
    }

    @ApiOperation(value = "查询当前登录人是否需要打卡")
    @PostMapping("/needWorkSign")
    @CrmLog
    public Result<NeedClock> needWorkSign(){
        return Result.ok(sfaWorkSignRecordService.needWorkSign());
    }
//    /**
////     * 自由签到查询当前登录人  所有签到组
////     * @return
////     */
//    @ApiOperation(value = "自由签到查询当前登录人  所有签到组")
//    @PostMapping("/findFreesignConfigList")
//    @CrmAPIDiscard
//    @CrmLog
//    public Result<SfaFreesignConfigRespVo> findFreesignConfigList(){
//        Result<SfaFreesignConfigRespVo> result = sfaFreesignConfigService.findFreesignConfigList();
//        return result;
//    }

//    /**
//     * 自由签到接口
//     * @param sfaWorkSignRecordReqVo
//     * @return
//     */
//    @ApiOperation(value = "自由签到接口")
//    @CrmAPIDiscard
//    @PostMapping("/goFreeSignIn")
//    @CrmLog
//    public Result goFreeSignIn(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo){
//        Result result = sfaWorkSignRecordService.goFreeSignIn(sfaWorkSignRecordReqVo);
//        return result;
//    }



    @ApiOperation(value = "请假-列表查询(我的提交的)")
    @PostMapping("/findSfaLeaveBpmList")
    @CrmLog
    public Result<PageResult<SfaLeaveRespVo>> findSfaLeaveBpmList(@RequestBody SfaLeaveListReqVo sfaLeaveReqVo) {
        PageResult<SfaLeaveRespVo> result = new PageResult<>();
        //获取当前登录人信息
        UserRedis userRedis = UserUtils.getUser();
        if (null!=userRedis && StringUtil.isNotEmpty(userRedis.getUsername())){
            // 默认查询当前登录人员申请
            if(StringUtils.isEmpty(sfaLeaveReqVo.getUserName())) {
                sfaLeaveReqVo.setUserName(userRedis.getUsername());
            }
            result = iSfaLeaveService.findList(sfaLeaveReqVo);
        }
        return Result.ok(result);
    }

    @ApiOperation(value = "请假-详情")
    @PostMapping("/findSfaLeaveById")
    @CrmLog
    public Result<SfaLeaveRespVo> findSfaLeaveById(@RequestBody CrmIdsReqVo idsReqVo) {
        Result<SfaLeaveRespVo> result = new Result();
        if(idsReqVo == null || idsReqVo.getIds() == null || idsReqVo.getIds().size() == 0) {
            result.error500("请输入业务主键");
            return result;
        }

        SfaLeaveListReqVo sfaLeaveReqVo = new SfaLeaveListReqVo();
        sfaLeaveReqVo.setId(idsReqVo.getIds().get(0));
        PageResult<SfaLeaveRespVo> pageResult = iSfaLeaveService.findList(sfaLeaveReqVo);
        if(pageResult != null && CollectionUtil.listNotEmptyNotSizeZero(pageResult.getData())) {
            result.setResult(pageResult.getData().get(0));
        }else {
            throw new BusinessException(idsReqVo.getIds().get(0)+"数据已经不存在了");
        }

        return result;
    }


    @ApiOperation(value = "请假-申请")
    @PostMapping("/goApplyLeave")
    @CrmLog
    public Result goApplyLeave(@RequestBody SfaLeaveReqVo sfaLeaveReqVo){
        Result result = iSfaLeaveService.goApplyLeave(sfaLeaveReqVo);
        return result;
    }

    @ApiOperation(value = "请假-计算时长")
    @PostMapping("/countApplyDays")
    @CrmLog
    public Result countApplyDays(@RequestBody SfaLeaveReqVo reqVo) {
        Result result = Result.ok();
        result.setResult(iSfaLeaveService.countApplyDays(reqVo).getLeaveDuration());

        return result;
    }

    @ApiOperation(value = "请假-追回")
    @PostMapping("/rollbackLeave")
    @CrmLog
    public Result rollbackLeave(@RequestBody CrmIdsReqVo idsReqVo) {
        Result result = new Result();
        if(idsReqVo == null || idsReqVo.getIds() == null || idsReqVo.getIds().size() == 0) {
            result.error500("业务主键不能为空");
        }
        result = iSfaLeaveService.rollbackLeave(idsReqVo.getIds().get(0));
        return result;
    }

    @ApiOperation(value = "请假-追加附件信息")
    @PostMapping("/addAttachment")
    @CrmLog
    public Result addAttachmentLeave(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
        Result result = iSfaLeaveService.addAttachment(sfaLeaveReqVo);
        return result;
    }

    @ApiOperation("请假-销假")
    @PostMapping("/cancelLeave")
    @CrmLog
    public Result cancelLeave(@RequestBody SfaAuditCancelReqVo reqVo) {
        return iSfaLeaveService.cancelLeave(reqVo);
    }

    @ApiOperation(value = "销假-详情")
    @PostMapping("/findSfaLeaveCancelById")
    @CrmLog
    public Result<SfaLeaveCancelInfoRespVo> findSfaLeaveCancelById(@RequestBody CrmIdsReqVo idsReqVo) {
        AssertUtils.isNotNull(idsReqVo.getIds(), "请输入业务组件");

        SfaAuditListLeaveCancelReqVo reqVo = new SfaAuditListLeaveCancelReqVo(){{setId(idsReqVo.getIds().get(0));}};
        PageResult<SfaLeaveCancelInfoRespVo> pageResult = iSfaLeaveCancelService.findInfoList(reqVo);
        if(pageResult == null || pageResult.getCount() != 1) {
            throw new BusinessException("销假id错误");
        }

        return Result.ok(pageResult.getData().get(0));
    }

    @ApiOperation("考勤历史")
    @PostMapping("/signHistoryList")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaSignHistoryListRespVo>> signHistoryList(@RequestBody SfaSignHistoryListReqVo reqVo) {
        PageResult<SfaSignHistoryListRespVo> pageResult = sfaWorkSignRecordService.findSignHistory(reqVo);

        if(pageResult != null && pageResult.getData() != null && pageResult.getData().size() > 0) {
            pageResult.getData().forEach(history -> {
                history.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc(history.getWorkSignStatus()));
            });
        }
        return Result.ok(pageResult);
    }

    @ApiOperation("签到详情")
    @PostMapping("/signInfo")
    @CrmLog
    @CrmDictMethod
    public Result<SfaSignHistoryListRespVo> signInfo(@RequestBody CrmIdsReqVo reqVo) {
        if(reqVo == null || reqVo.getIds() == null || reqVo.getIds().size() == 0) {
            Result<SfaSignHistoryListRespVo> result = new Result<>();
            return result.error500("主键id不能为空");
        }
        // 列表请求对象组装
        SfaSignHistoryListReqVo listReqVo = new SfaSignHistoryListReqVo();
        listReqVo.setId(reqVo.getIds().get(0));

        // 返回对象
        SfaSignHistoryListRespVo vo = new SfaSignHistoryListRespVo();

        // 获取查询到的对象
        Result<PageResult<SfaSignHistoryListRespVo>> result = signHistoryList(listReqVo);
        if(result.getResult().getData() != null && result.getResult().getData().size() > 0) {
            vo = result.getResult().getData().get(0);
            vo.setGooffTime(vo.getSfaSignTime());
            vo.setGotoTime(vo.getSfaSignTime());
            List<SfaWorkSignPictureEntity> pictureEntities = sfaWorkSignPictureService.list(Wrappers.lambdaQuery(SfaWorkSignPictureEntity.class).eq(SfaWorkSignPictureEntity::getWsRecordId, vo.getId()));
            List<SfaWorkSignPictureRespVo> sfaWorkSignPictureRespVos = CrmBeanUtil.copyList(pictureEntities, SfaWorkSignPictureRespVo.class);
            vo.setPictureList(sfaWorkSignPictureRespVos);
        }

        return Result.ok(vo);
    }

//    /**
//     * 出差申请  我的申请列表查询
//     * @return
//     */
//    @ApiOperation(value = "出差申请我的申请列表查询")
//    @PostMapping("/findSfaTravelList")
//    @CrmAPIDiscard
//    @CrmLog
//    public PageResult<SfaTravelRespVo> findSfaTravelList(@RequestBody SfaTravelReqVo sfaLeaveReqVo) {
//        PageResult<SfaTravelRespVo> result = new PageResult<>();
//        //获取当前登录人信息
//        UserRedis userRedis = UserUtils.getUser();
//        if (null!=userRedis && StringUtil.isNotEmpty(userRedis.getUsername())){
//            sfaLeaveReqVo.setApplyUserName(userRedis.getUsername());
//            result = iSfaTravelService.findList(sfaLeaveReqVo);
//        }
//        return result;
//    }
//
//
//    /**
//     * 出差申请  我的审批列表查询
//     * @return
//     */
//    @ApiOperation(value = "出差申请列表查询")
//    @PostMapping("/findSfaTravelBpmList")
//    @CrmAPIDiscard
//    @CrmLog
//    public PageResult<SfaTravelRespVo> findSfaTravelBpmList(@RequestBody SfaTravelReqVo sfaLeaveReqVo) {
//        PageResult<SfaTravelRespVo> result = new PageResult<>();
//        //获取当前登录人信息
//        UserRedis userRedis = UserUtils.getUser();
//        if (null!=userRedis && StringUtil.isNotEmpty(userRedis.getUsername())){
//            sfaLeaveReqVo.setApplyUserName(userRedis.getUsername());
//            result = iSfaTravelService.findList(sfaLeaveReqVo);
//        }
//        return result;
//    }
//
//
//
//    /**
//     * 出差申请接口
//     * @param sfaLeaveReqVo
//     * @return
//     */
//    @ApiOperation(value = "出差申请接口")
//    @PostMapping("/goApplyTravel")
//    @CrmAPIDiscard
//    @CrmLog
//    public Result goApplyTravel(@RequestBody SfaTravelReqVo sfaLeaveReqVo){
//        Result result = iSfaTravelService.goApplyTravel(sfaLeaveReqVo);
//        return result;
//    }
//

}
