package com.biz.crm.moblie.controller.workbench;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.component.impl.DefaultVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepDefaultEntity;
import com.biz.crm.visitstep.model.SfaVisitStepDefaultEsData;
import com.biz.crm.visitstep.req.GetDefaultPageReq;
import com.biz.crm.visitstep.service.impl.SfaVisitStepDefaultServiceEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;


/**
 * 工作台-默认步骤模板
 *  @author: luoqi
 *  @Date: 2021-3-24 13:55
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@RestController
@RequestMapping("sfaWorkbenchDefController")
@Api(tags = "小程序端-工作台-日常工作-默认步骤模板")
public class SfaWorkbenchDefController {

    @Resource
    private SfaVisitStepDefaultServiceEsImpl sfaVisitStepDefaultServiceEsImpl;

    @Resource
    private DefaultVisitStepExecutor defaultVisitStepExecutor;



    /**
     * 工作台-默认模板
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation("工作台-默认步骤模板")
    @PostMapping("executeForWorkbenchDef")
    @CrmLog
    public Result executeForWorkbenchDef(@RequestBody VisitStepExecuteReq<SfaVisitStepDefaultEntity> visitStepExecuteReq) {
        this.defaultVisitStepExecutor.executeForWorkbench(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 工作台-默认模板
     *
     * @param req
     * @return
     */
    @ApiOperation("工作台-查询默认步骤模板列表")
    @PostMapping("getWorkbenchDefPage")
    @CrmLog
    public Result<PageResult<SfaVisitStepDefaultEsData>> getWorkbenchDefPage(@RequestBody GetDefaultPageReq req) {

        return Result.ok(this.sfaVisitStepDefaultServiceEsImpl.getWorkbenchDefaultPage(req));
    }

    /**
     * 加载工作台编辑页面数据-默认模板
     * @param loadParam
     * @return
     */
    @CrmLog
    @PostMapping("loadEditPageForWorkbenchDef")
    @ApiOperation("工作台-查询默认步骤模板详细信息")
    public Result<SfaVisitStepDefaultEsData> loadEditPageForWorkbenchDef(@RequestBody ExecutorWorkbenchLoadReq loadParam){
        SfaVisitStepDefaultEsData esData = (SfaVisitStepDefaultEsData) defaultVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        return Result.ok(esData);
    }



}
