package com.biz.crm.moblie.controller.workbench.req;

import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeProductRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("工作台-订单采集-方案活动执行数据请求VO")
public class OrderAsDataReq<T extends OrderAsDataReq.OrderItemAsReqVo> extends OrderWorkbenchDataReq implements ClientReq {


    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    private String clientType;

    @ApiModelProperty("拜访ID")
    private String visitPlanInfoId;

    @ApiModelProperty("活动方案产品列表")
    private List<SfaActSchemeProductRespVo> actSchemeProductList;

    @Override
    public void convert() {
        //TODO 方案活动转换逻辑 将方案活动商品列表转换成订单商品
        List<OrderItemAsReqVo> orderItemAsReqVos = Lists.newArrayList();
        if(CollectionUtils.isEmpty(this.actSchemeProductList)){
            return;
        }
        this.actSchemeProductList.forEach(o -> {
            OrderItemAsReqVo itemAsReqVo = CrmBeanUtil.copy(o, OrderItemAsReqVo.class);

            String priceStr = o.getPrice();
            BigDecimal price = null == priceStr ? null : new BigDecimal(priceStr);
            //特殊字段处理
            itemAsReqVo.setPrice(price);
//            itemAsReqVo.setPicUrl(o.ge);
//            itemAsReqVo.setProductCode(o.getProductCode());
//            itemAsReqVo.setProductName(o.getProductName());
//            itemAsReqVo.setSeriesCode(o.getSeriesCode());
//            itemAsReqVo.setSetmealName(o.getSeriesName());
//            itemAsReqVo.setQuantity(o.getQuantity());
//            itemAsReqVo.setUnit(o.getUnit());
//            itemAsReqVo.setUnitName(o.getUnitName());

            orderItemAsReqVos.add(itemAsReqVo);
        });
        this.setSfaVisitStepOrderItems((List<T>) orderItemAsReqVos);
    }

    @Data
    @ApiModel("拜访步骤-订单采集-方案活动执行数据请求VO-订单商品项")
    public static class OrderItemAsReqVo extends OrderItemReqVo {
        /**
         * 行类型(1-本品,2-赠品)
         */
        @ApiModelProperty("行类型(1-本品,2-赠品)")
        private String itmeType;

        /**
         * 执行id
         */
        @ApiModelProperty("执行id")
        private String executionId;
        /**
         * 方案套餐id
         */
        @ApiModelProperty("方案套餐id")
        private String setmealId;

        @ApiModelProperty("方案套餐名称")
        private String setmealName;
    }

}
