package com.biz.crm.moblie.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 这是Sfa客户审批表的实体
 *
 * @author YuanZiJian
 * @date 2020/12/31 16:20
 * @version: V1.0
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_customer")
@CrmTable(name = "sfa_customer", tableNote = "经销商审批表",indexes = {
        @Index(name = "sfa_customer_index1",columnList = "process_no"),
        @Index(name = "sfa_customer_index2",columnList = "customer_code")
})
public class SfaCustomerMsgEntity extends CrmTreeEntity<SfaCustomerMsgEntity> {

    /**
     * 流程编码
     */
    @CrmColumn(name = "process_no",length = 32, note = "流程编码")
    private String processNo;

    /**
     * 审批表单FormNo编码
     */
    @CrmColumn(name = "customer_form_no",length = 64, note = "审批表单FormNo编码")
    private String customerFormNo;


    /**
     * 渠道
     */
    @CrmColumn(name = "channel",length = 10, note = "渠道")
    private String channel;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code",length = 64, note = "客户编码")
    private String customerCode;

    /**
     * 客户组织编码
     */
    @CrmColumn(name = "customer_org_code",length = 64, note = "客户组织编码")
    private String customerOrgCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name",length = 64, note = "客户名称")
    private String customerName;

    /**
     * 客户类型
     */
    @CrmColumn(name = "customer_type",length = 64, note = "客户类型")
    private String customerType;

    /**
     * 操作类型
     */
    @CrmColumn(name = "operate_type",length = 64, note = "操作类型")
    private String operateType;

    /**
     * 企业组织编码
     */
    @CrmColumn(name = "org_code",length = 64, note = "企业组织编码")
    private String orgCode;


    /**
     * 市
     */
    @CrmColumn(name = "city_code",length = 64, note = "市")
    private String cityCode;

    /**
     * 区
     */
    @CrmColumn(name = "district_code",length = 64, note = "区")
    private String districtCode;

    /**
     * 省
     */
    @CrmColumn(name = "province_code",length = 64, note = "省")
    private String provinceCode;

    /**
     * 注册地址
     */
    @CrmColumn(name = "registered_address",length = 100, note = "注册地址")
    private String registeredAddress;

    /**
     * 工程名
     */
    @CrmColumn(name = "project_name",length = 100, note = "工程名")
    private String projectName;

    /**
     * 客户联系方式
     */
    @CrmColumn(name = "customer_contact",length = 64, note = "客户联系方式")
    private String customerContact;
    /**
     * 客户法人代表
     */
    @CrmColumn(name = "legal_representative",length = 64, note = "客户法人代表")
    private String legalRepresentative;
    /**
     * 用户帐号
     */
    @CrmColumn(name = "user_name",length = 32, note = "用户帐号")
    private String userName;
    /**
     * 是否是主客户：N否Y是,PrimaryUserConstant
     */
    @CrmColumn(name = "customer_primary",length = 6, note = "是否是主客户：N否Y是,PrimaryUserConstant")
    private String customerPrimary;

    /**
     * 锁定状态：009正常，003冻结
     */
    @CrmColumn(name = "lock_state",length = 6, note = "锁定状态：009正常，003冻结")
    private String lockState;
    /**
     * 经度
     */
    @CrmColumn(name = "longitude",length = 64, note = "经度")
    private String longitude;
    /**
     * 纬度
     */
    @CrmColumn(name = "latitude",length = 64, note = "纬度")
    private String latitude;
    /**
     * erp编码
     */
    @CrmColumn(name = "erp_code",length = 64, note = "erp编码")
    private String erpCode;
    /**
     * 审批状态,枚举ActApproveStatusEnum
     */
    @CrmColumn(name = "act_approve_status",length = 64, note = "审批状态,枚举ActApproveStatusEnum")
    private String actApproveStatus;
    /**
     * 对接人列表Json
     */
    @CrmColumn(name = "dockings",mysqlType = "text", oracleType = "CLOB", note = "对接人列表Json")
    private String dockings;
    /**
     * 联系人列表Json
     */
    @CrmColumn(name = "contacts",mysqlType = "text", oracleType = "CLOB", note = "联系人列表Json")
    private String contacts;
    /**
     * 销售区域列表Json
     */
    @CrmColumn(name = "sale_areas",mysqlType = "text", oracleType = "CLOB", note = "销售区域列表Json")
    private String saleAreas;
    /**
     * 客户编码集合Json
     */
    @CrmColumn(name = "customer_codes",mysqlType = "text", oracleType = "CLOB", note = "客户编码集合Json")
    private String customerCodes;
    /**
     * 组织编码集合Json
     */
    @CrmColumn(name = "org_codes",mysqlType = "text", oracleType = "CLOB", note = "组织编码集合Json")
    private String orgCodes;

    /**
     * 审批意见
     */
    @CrmColumn(name = "act_remarks",length = 200, note = "审批意见")
    private String actRemarks;
}
