package com.biz.crm.moblie.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 对接人实体
 * @author YuanZiJian
 * @date 2021/1/20 14:58
 * @version: V1.0
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_customer_docking")
@CrmTable(name = "sfa_customer_docking", tableNote = "经销商对接人表",indexes = {
        @Index(name = "sfa_customer_docking_index1",columnList = "customer_id")
})
public class SfaDockingEntity extends CrmExtTenEntity {

    @ApiModelProperty("审批客户编码")
    @CrmColumn(name = "customer_id", length = 64, note = "审批客户编码")
    private String customerId;

    @ApiModelProperty("职位编码")
    @CrmColumn(name = "position_code", length = 64, note = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @CrmColumn(name = "position_name", length = 64, note = "职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    @CrmColumn(name = "org_code", length = 64, note = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @CrmColumn(name = "org_name", length = 64, note = "组织名称")
    private String orgName;

    @ApiModelProperty("联系方式")
    @CrmColumn(name = "contact", length = 64, note = "联系方式")
    private String contact;

    @ApiModelProperty("用户帐号")
    @CrmColumn(name = "user_name", length = 64, note = "用户帐号")
    private String userName;

    @ApiModelProperty("用户名称")
    @CrmColumn(name = "full_name", length = 64, note = "用户名称")
    private String fullName;

    @ApiModelProperty("销售公司编码")
    @CrmColumn(name = "sale_company", length = 64, note = "销售公司编码")
    private String saleCompany;
}
