package com.biz.crm.moblie.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 供货关系实体
 * @author YuanZiJian
 * @date 2021/1/20 14:47
 * @version: V1.0
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_terminal_supply")
@CrmTable(name = "sfa_terminal_supply", tableNote = "供货关系表")
public class SfaSupplyEntity extends CrmExtTenEntity {

    @ApiModelProperty("审批终端Id")
    @CrmColumn(name = "terminal_id", length = 64, note = "审批终端Id")
    private String terminalId;

    @ApiModelProperty("组织编码")
    @CrmColumn(name = "org_code", length = 64, note = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @CrmColumn(name = "org_name", length = 64, note = "组织名称")
    private String orgName;

    @ApiModelProperty("用户名称")
    @CrmColumn(name = "full_name", length = 64, note = "用户名称")
    private String fullName;

    @ApiModelProperty("上级客户编码")
    @CrmColumn(name = "customer_code", length = 64, note = "上级客户编码")
    private String customerCode;

    @ApiModelProperty("上级客户名称")
    @CrmColumn(name = "customer_name", length = 64, note = "上级客户名称")
    private String customerName;

    @ApiModelProperty("职位编码")
    @CrmColumn(name = "position_code", length = 64, note = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @CrmColumn(name = "position_name", length = 64, note = "职位名称")
    private String positionName;
}
