package com.biz.crm.moblie.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 这是Sfa终端审批的实体
 *
 * @author YuanZiJian
 * @date 2020/12/31 16:21
 * @version: V1.0
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_terminal")
@CrmTable(name = "sfa_terminal", tableNote = "终端审批表",indexes = {
        @Index(name = "sfa_terminal_index1",columnList = "terminal_code")
})
public class SfaTerminalEntity extends CrmTreeEntity<SfaTerminalEntity> {
    /**
     *  流程编号
     */
    @CrmColumn(name = "process_no",length = 32, note = "流程编号")
    private String processNo;

    /**
     * 门店编码查询条件Json（弃用)
     */
    @CrmColumn(name = "terminal_codes",mysqlType = "text", oracleType = "CLOB", note = "门店编码查询条件Json（弃用)")
    private String terminalCodes;

    /**
     * 左侧组织查询编码
     */
    @CrmColumn(name = "code",length = 64, note = "左侧组织查询编码")
    private String code;

    /**
     * 左侧组织查询编码集合Json（弃用)
     */
    @CrmColumn(name = "org_codes",mysqlType = "text", oracleType = "CLOB", note = "左侧组织查询编码集合Json（弃用)")
    private String orgCodes;

    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code",length = 64, note = "终端编码")
    private String terminalCode;

    /**
     * 终端名称
     */
    @CrmColumn(name = "terminal_name",length = 64, note = "终端名称")
    private String terminalName;

    /**
     * 终端类型
     */
    @CrmColumn(name = "terminal_type",length = 64, note = "终端类型")
    private String terminalType;

    /**
     * 终端类型名称
     */
    @CrmColumn(name = "terminal_type_name",length = 64, note = "终端类型名称")
    private String terminalTypeName;

    /**
     * 所属组织编码
     */
    @CrmColumn(name = "org_code",length = 64, note = "所属组织编码")
    private String orgCode;

    /**
     * 所属组织名字
     */
    @CrmColumn(name = "org_name",length = 64, note = "所属组织名字")
    private String orgName;

    /**
     * 客户组织编码
     */
    @CrmColumn(name = "customer_org_code",length = 64, note = "客户组织编码")
    private String customerOrgCode;

    /**
     * 客户组织名称
     */
    @CrmColumn(name = "customer_org_name",length = 64, note = "流程编号")
    private String customerOrgName;

    /**
     * 渠道
     */
    @CrmColumn(name = "channel",length = 255, note = "渠道")
    private String channel;

    /**
     * 渠道名字
     */
    @CrmColumn(name = "channel_name",length = 64, note = "渠道名字")
    private String channelName;

    /**
     * 营业执照法人姓名
     */
    @CrmColumn(name = "license_person_name",length = 255, note = "营业执照法人姓名")
    private String licensePersonName;

    /**
     * 营业执照注册号
     */
    @CrmColumn(name = "license_register_number",length = 255, note = "营业执照注册号")
    private String licenseRegisterNumber;

    /**
     * 营业执照企业名称
     */
    @CrmColumn(name = "license_firm_name",length = 255, note = "营业执照企业名称")
    private String licenseFirmName;

    /**
     * 终端地址
     */
    @CrmColumn(name = "terminal_address",length = 200, note = "终端地址")
    private String terminalAddress;

    /**
     * 省编码
     */
    @CrmColumn(name = "province_code",length = 64, note = "省编码")
    private String provinceCode;

    /**
     * 市编码
     */
    @CrmColumn(name = "city_code",length = 64, note = "市编码")
    private String cityCode;

    /**
     * 区编码
     */
    @CrmColumn(name = "district_code",length = 64, note = "区编码")
    private String districtCode;

    /**
     * 店招照片
     */
    @CrmColumn(name = "shop_image_path",length = 255, note = "店招照片")
    private String shopImagePath;

    /**
     * 营业执照照片
     */
    @CrmColumn(name = "license_image_path",length = 255, note = "营业执照照片")
    private String licenseImagePath;

    /**
     * 经度
     */
    @CrmColumn(name = "longitude",length = 64, note = "经度")
    private String longitude;

    /**
     * 纬度
     */
    @CrmColumn(name = "latitude",length = 64, note = "纬度")
    private String latitude;

    /**
     * 客户分类
     */
    @CrmColumn(name = "customer_classification",length = 64, note = "客户分类")
    private String customerClassification;

    /**
     * 枚举ActApproveStatusEnum
     */
    @CrmColumn(name = "act_approve_status",length = 64, note = "枚举ActApproveStatusEnum")
    private String actApproveStatus;

    /**
     * 联系人信息集合Json（弃用)
     */
    @CrmColumn(name = "contacts",mysqlType = "text", oracleType = "CLOB", note = "联系人信息集合Json（弃用)")
    private String contacts;

    /**
     * 供货关系集合Json（弃用)
     */
    @CrmColumn(name = "supplys",mysqlType = "text", oracleType = "CLOB", note = "供货关系集合Json（弃用)")
    private String supplys;

    /**
     * 终端审批的formNo
     */
    @CrmColumn(name = "form_no",length = 64, note = "终端审批的formNo")
    private String formNo;
    /**
     * 审批意见
     */
    @CrmColumn(name = "act_remarks",mysqlType = "text", oracleType = "CLOB", note = "审批意见")
    private String actRemarks;
    /**
     * 高德地图ID
     */
    @CrmColumn(name = "amap_id", length = 64)
    private String amapId;
}
