package com.biz.crm.moblie.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.approval.req.SfaApprovalListReqVo;
import com.biz.crm.nebular.sfa.approval.resp.SfaApprovalListRespVo;
import com.biz.crm.util.Result;

/**
 * 小程序端 我的审批
 * @author YuanZiJian
 * @date 2021/3/10 16:34
 * @version: V1.0
 */
public interface SfaApprovalService {
    /**
     * 获取当前用户的审批列表———app端——我的审批用
     * @method getApprovalList
     * @date: 2021/3/10 17:06
     * @author: YuanZiJian
     * @param sfaApprovalListReqVo 接收查询条件
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.approval.resp.SfaApprovalListRespVo>
     */
    PageResult<SfaApprovalListRespVo> getApprovalList(SfaApprovalListReqVo sfaApprovalListReqVo);

    /**
     * 获取当前登录人 抄送未读的数量 抄送的气泡
     * @method countSend
     * @date: 2021/3/11 16:45
     * @author: YuanZiJian
     * @return com.biz.crm.util.Result
     */
    Result countSend();


    /**
     * 获取当前登录人待办的数量 用于工作台页面——我的审批——气泡显示
     * @method countSend
     * @date: 2021/3/11 16:45
     * @author: YuanZiJian
     * @return com.biz.crm.util.Result
     */
    Result<Long> countApproving();
}
