package com.biz.crm.moblie.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.model.SfaCustomerMsgEntity;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaCustomerMsgRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepColletProductEntity;

import java.util.List;

/**
 * 对客户（经销商）操作的接口
 * @author YuanZiJian
 * @date 2020/12/29 16:46
 * @version: V1.0
 */
public interface SfaCustomerService extends IService<SfaCustomerMsgEntity> {
    /**
     * 查询客户（经销商）列表
     * 默认查询登陆用户的职位及其下级职位的所有客户（经销商）
     * @method findCustomer
     * @date: 2020/12/29 16:48
     * @author: YuanZiJian
     * @return com.biz.crm.util.Result<java.util.List<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     */
    Result<List<MdmCustomerMsgRespVo>> findCustomer();

    /**
     * 添加客户经销商
     * @method saveCustomer
     * @date: 2020/12/30 10:43
     * @author: YuanZiJian
     * @param mdmCustomerMsgReqVo
     * @return void
     */
    void saveCustomer(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 更新客户经销商
     * @method updateCustomer
     * @date: 2020/12/30 10:43
     * @author: YuanZiJian
     * @param mdmCustomerMsgReqVo
     * @return void
     */
    void updateCustomer(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);
    /**
     * 更新审批状态
     * @method updateActApproveStatus
     * @date: 2021/1/5 15:07
     * @author: YuanZiJian
     * @param actApproveStatus 审批状态
     * @return void
     */
    void updateActApproveStatus (ActivitiCallBackVo activitiCallBackVo);

    /**
     * 查询所有在sfa审核表中的经销商数据-小程序端
     * @method findAllTerminal
     * @date: 2021/1/6 10:27
     * @author: YuanZiJian
     * @param sfaCustomerReqVo 查询参数
     */
    PageResult<MdmCustomerMsgReqVo> findAllSfaCustomer (SfaCustomerReqVo sfaCustomerReqVo);

    /**
     * 更新经销商审批状态——小程序端
     * @param id 经销商id
     * @param remark 审批备注
     * @param actApproveStatus 审批状态
     */
    void updateSfaActApproveStatus(String id,String remark,String actApproveStatus);

    /**
     * 根据id获取审批经销商的信息-小程序端
     * @method querySfaTerminalVo
     * @date: 2021/1/6 13:48
     * @author: YuanZiJian
     * @param id 经销商id
     */
    Result<SfaCustomerMsgRespVo> querySfaCustomerVo(String id);
    /**
     * 待处理的经销商审批信息
     * @method countCustomer
     * @date: 2021/1/6 18:19
     * @author: YuanZiJian
     * @return com.biz.crm.util.Result<java.lang.Integer>
     */
    Result<Integer> countCustomer();

    /**
     * 获取客户新增数
     */
    Integer getCustomerNum(String dateFlag);

    /**
     * 新增客户（计算绩效、积分）
     * @param mdmCustomerMsgRespVo
     * @param fromType
     */
    void countAchievementAndIntegral(MdmCustomerMsgRespVo mdmCustomerMsgRespVo, String fromType);
}
