package com.biz.crm.moblie.service.impl;

import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.act.TaActProcessFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.moblie.service.SfaApprovalService;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.CopyTaskRspVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.activiti.vo.BpmQueryVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.approval.req.SfaApprovalListReqVo;
import com.biz.crm.nebular.sfa.approval.resp.SfaApprovalListRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 我的审批
 * @author YuanZiJian
 * @date 2021/3/10 17:21
 * @version: V1.0
 */
@Service
public class SfaApprovalServiceImpl implements SfaApprovalService {

    private static final String processName = "SFA";

    @Resource
    ActivitiMobileFeign activitiMobileFeign;
    @Resource
    MdmPositionFeign mdmPositionFeign;
    @Resource
    TaActProcessFeign taActProcessFeign;
    @Resource
    private TaActBaseFeign taActBaseFeign;

    /**
     * 获取当前用户的待办和已办列表———app端——我的审批用
     *
     * @param sfaApprovalListReqVo 接收查询条件
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.approval.resp.SfaApprovalListRespVo>
     * @method getApprovalList
     * @date: 2021/3/10 17:06
     * @author: YuanZiJian
     */
    @Override
    public PageResult<SfaApprovalListRespVo> getApprovalList(SfaApprovalListReqVo sfaApprovalListReqVo) {
        AssertUtils.isNotEmpty(sfaApprovalListReqVo.getApprovalState(),"请传入审批状态");
        //判断是否为抄送
        if(ActivitiEnum.approvalState.SEND.getVal().equals(sfaApprovalListReqVo.getApprovalState())){
            return getApprovalSendList(sfaApprovalListReqVo);
        }
        //封装查询条件
        TaskQueryReqVO taskQuery = getTaskQuery(sfaApprovalListReqVo);
        Result<PageResult<TaskRspVO>> currentTask  = null;
        //判断是待办还是已办
        if(ActivitiEnum.approvalState.NOT_DONE.getVal().equals(sfaApprovalListReqVo.getApprovalState())){
            currentTask = activitiMobileFeign.findCurrentTask(taskQuery);
        }else if(ActivitiEnum.approvalState.DONE.getVal().equals(sfaApprovalListReqVo.getApprovalState())){
            currentTask = activitiMobileFeign.findDoneTask(taskQuery);
        }else {
            throw new BusinessException("审批状态不正确");
        }
        //查询
        PageResult<TaskRspVO> result =
                Optional.ofNullable(ApiResultUtil.objResult(currentTask, true)).orElse(PageResult.empty());
        List<TaskRspVO> data = result.getData();
        ArrayList<SfaApprovalListRespVo> respVos = new ArrayList<>();
        //不为空则为其中信息封装相关信息
        if(CollectionUtil.listNotEmpty(data)){
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            data.forEach(item->{
                SfaApprovalListRespVo respVo = CrmBeanUtil.copy(item, SfaApprovalListRespVo.class);
                respVo.setApprovalType(item.getCostType());
                respVo.setId(item.getFormNo());
                respVo.setCreateTime(simpleDateFormat.format(item.getCreateTime()));
                respVo.setStartUserName(item.getStartUserName());
                respVo.setStartUserCode(item.getStartUserCode());
                respVo.setOrgName(item.getStartOrgName());
                respVo.setProcessStateName(item.getProcessStateDesc());
                respVos.add(respVo);
            });
        }
        return PageResult.<SfaApprovalListRespVo>builder()
                .data(respVos)
                .count(result.getCount())
                .build();
    }

    /**
     * 获取当前登录抄送未读的数量
     *
     * @return com.biz.crm.util.Result
     * @method countSend
     * @date: 2021/3/11 16:45
     * @author: YuanZiJian
     */
    @Override
    public Result countSend() {
        UserRedis userRedis = UserUtils.getUser();
        if(null == userRedis){
            throw new BusinessException("未获取到用户会话信息，请重新登陆后重试！");
        }
        Integer count = ApiResultUtil.objResult(taActProcessFeign.countCopyTask(new CopyTaskReqVO().setUserCode(userRedis.getUsername()).setStatus(1)));
        return Result.ok(count);
    }

    /**
     * 获取当前登录人待办的数量 用于工作台页面——我的审批——气泡显示
     *
     * @return com.biz.crm.util.Result
     * @method countSend
     * @date: 2021/3/11 16:45
     * @author: YuanZiJian
     */
    @Override
    public Result<Long> countApproving() {
        BpmQueryVo queryVo = new BpmQueryVo(){{
           this.setPageNum(1);
           this.setPageSize(10);
        }};
        PageResult<CurrentTaskVo> currentTaskVoPageResult = ApiResultUtil.objResult(taActBaseFeign.listByPositionCode(queryVo));
        if(currentTaskVoPageResult==null){
            return Result.ok(0L);
        }
        return Result.ok(currentTaskVoPageResult.getCount());
    }


    /**
     * 获取当前用户的抄送列表———app端——我的审批用
     *
     * @param sfaApprovalListReqVo 接收查询条件
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.approval.resp.SfaApprovalSendListRespVo>
     * @method getApprovalSendList
     * @date: 2021/3/11 15:02
     * @author: YuanZiJian
     */
    private PageResult<SfaApprovalListRespVo>  getApprovalSendList(SfaApprovalListReqVo sfaApprovalListReqVo) {
        CopyTaskReqVO copyTaskQuery = getCopyTaskQuery(sfaApprovalListReqVo);
//        Result<PageResult<CopyTaskRspVO>> myCopyTask = activitiMobileFeign.findMyCopyTask(copyTaskQuery);
        PageResult<CopyTaskRspVO> myCopyTask = ApiResultUtil.objResult(activitiMobileFeign.findMyCopyTask(copyTaskQuery), true);
        if (null == myCopyTask){
            return PageResult.<SfaApprovalListRespVo>builder()
                    .data(Lists.newArrayList())
                    .count(0L)
                    .build();
        }
        //查询
        List<CopyTaskRspVO> data = myCopyTask.getData();
        ArrayList<SfaApprovalListRespVo> respVos = new ArrayList<>();
        //不为空则为其中信息封装相关信息
        if(CollectionUtil.listNotEmpty(data)){
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List<String> posStrings = data.stream().map(CopyTaskRspVO::getFromPosCode).collect(Collectors.toList());
            //通过职位查询到对应的组织
            Result<List<MdmPositionUserOrgRespVo>> batchByIds = mdmPositionFeign.detailBatchByIds(posStrings);
            Map<String, String> stringMap = batchByIds.getResult().stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, MdmPositionUserOrgRespVo::getOrgName));
            data.forEach(item->{
                SfaApprovalListRespVo respVo = CrmBeanUtil.copy(item, SfaApprovalListRespVo.class);
                respVo.setApprovalType(item.getCostType());
                respVo.setId(item.getFormNo());
                respVo.setCreateTime(simpleDateFormat.format(item.getCreateTime()));
                respVo.setOrgName(stringMap.get(item.getFromPosCode()));
                respVo.setStartUserCode(item.getStartUserCode());
                respVo.setStartUserName(item.getStartUserName());
                respVos.add(respVo);
            });
        }
        return PageResult.<SfaApprovalListRespVo>builder()
                .data(respVos)
                .count(myCopyTask.getCount())
                .build();
    }

    /**
     * 封装抄送查询条件
     * @method getCopyTaskQuery
     * @date: 2021/3/11 15:07
     * @author: YuanZiJian
     * @param sfaApprovalListReqVo
     * @return com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO
     */
    private CopyTaskReqVO getCopyTaskQuery(SfaApprovalListReqVo sfaApprovalListReqVo){
        CopyTaskReqVO copyTaskReqVO = new CopyTaskReqVO();
        copyTaskReqVO.setUserCode(UserUtils.getUser().getUsername());
        copyTaskReqVO.setProcessName(processName);
        copyTaskReqVO.setPageNum(sfaApprovalListReqVo.getPageNum());
        copyTaskReqVO.setPageSize(sfaApprovalListReqVo.getPageSize());
        if(StringUtils.isNotEmpty(sfaApprovalListReqVo.getRealName())){
            copyTaskReqVO.setFromUserName(sfaApprovalListReqVo.getRealName());
        }
        if (StringUtils.isNotEmpty(sfaApprovalListReqVo.getApprovalType())){
            copyTaskReqVO.setProcessName(processName+ActivitiEnum.getTitleByCostType(sfaApprovalListReqVo.getApprovalType()));
        }
        return copyTaskReqVO;
    }


    /**
     * 封装查询条件
     * @method getTaskQuery
     * @date: 2021/3/10 20:10
     * @author: YuanZiJian
     * @param sfaApprovalListReqVo 条件接收Vo
     * @return com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO
     */
    private TaskQueryReqVO getTaskQuery(SfaApprovalListReqVo sfaApprovalListReqVo){
        //封装需要到流程中心查询的条件
        TaskQueryReqVO queryReqVO = new TaskQueryReqVO();
        queryReqVO.setUserCode(UserUtils.getUser().getUsername());
        queryReqVO.setProcessName(processName);
        queryReqVO.setPageNum(sfaApprovalListReqVo.getPageNum());
        queryReqVO.setPageSize(sfaApprovalListReqVo.getPageSize());
        if(StringUtils.isNotEmpty(sfaApprovalListReqVo.getRealName())){
            queryReqVO.setStartUserName(sfaApprovalListReqVo.getRealName());
        }
        if (StringUtils.isNotEmpty(sfaApprovalListReqVo.getApprovalType())){
            queryReqVO.setProcessName(processName+ActivitiEnum.getTitleByCostType(sfaApprovalListReqVo.getApprovalType()));
        }
        return queryReqVO;
    }
}
