package com.biz.crm.moblie.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaWorkSummaryEnum;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.ClientEnum;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.moblie.mapper.SfaCustomerMsgMapper;
import com.biz.crm.moblie.model.SfaContactEntity;
import com.biz.crm.moblie.model.SfaCustomerMsgEntity;
import com.biz.crm.moblie.model.SfaDockingEntity;
import com.biz.crm.moblie.service.SfaContactService;
import com.biz.crm.moblie.service.SfaCustomerService;
import com.biz.crm.moblie.service.SfaDockingService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.enums.ChannelEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaCustomerMsgRespVo;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * sfa经销商相关操作
 * @author YuanZiJian
 * @date 2020/12/29 16:49
 * @version: V1.0
 */
@Service
@Slf4j
public class SfaCustomerServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaCustomerMsgMapper, SfaCustomerMsgEntity> implements SfaCustomerService {
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private TaActBaseFeign taActBaseFeign;
    @Resource
    private ActivitiMobileFeign mobileFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmCusOrgFeign mdmCusOrgFeign;
    @Resource
    private SfaContactService sfaContactService;
    @Resource
    private SfaDockingService sfaDockingService;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;


    private static String ONE = "1";
    private static String TWO ="2";
    private static String THREE ="3";
    /**
     * 查询客户（经销商）列表
     * 默认查询登陆用户的职位及其下级职位的所有客户（经销商）
     *
     * @return com.biz.crm.util.Result<java.util.List < com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     * @method findCustomer
     * @date: 2020/12/29 16:48
     * @author: YuanZiJian
     */
    @Override
    public Result<List<MdmCustomerMsgRespVo>> findCustomer() {
        MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo = new MdmPositionCustomerSearchReqVo();
        mdmPositionCustomerSearchReqVo.setPositionCode(UserUtils.getUser().getPoscode());
        Result<List<MdmCustomerMsgRespVo>> currentAndSubPositionCustomer = mdmCustomerMsgFeign.findCurrentAndSubPositionCustomer(mdmPositionCustomerSearchReqVo);
        return currentAndSubPositionCustomer;
    }

    /**
     * 添加客户经销商
     * 先提交给审批
     *
     * @param mdmCustomerMsgReqVo
     * @return void
     * @method saveCustomer
     * @date: 2020/12/30 10:43
     * @author: YuanZiJian
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveCustomer(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        //基本的字段校验
        checkVo(mdmCustomerMsgReqVo);
        mdmCustomerMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        SfaCustomerMsgEntity sfaCustomerMsgEntity = CrmBeanUtil.copy(mdmCustomerMsgReqVo, SfaCustomerMsgEntity.class);
        //保存审批信息到sfa终端表
        this.saveOrUpdate(sfaCustomerMsgEntity);
        //保存联系人和对接人信息
        saveSfaCustomerEntity(mdmCustomerMsgReqVo, sfaCustomerMsgEntity);
        sfaCustomerMsgEntity.setCustomerFormNo(sfaCustomerMsgEntity.getId());
        //提交审批并保存流程编码
        String processNo = ActivityUtils.startProcess(createCustomerStartProcessReqVo(sfaCustomerMsgEntity.getCustomerFormNo()));
        sfaCustomerMsgEntity.setProcessNo(processNo);
        this.saveOrUpdate(sfaCustomerMsgEntity);
    }

    /**
     * 更新客户经销商
     * 先提交给审批
     *
     * @param mdmCustomerMsgReqVo
     * @return void
     * @method updateCustomer
     * @date: 2020/12/30 10:43
     * @author: YuanZiJian
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCustomer(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        //基本的字段校验
        checkVo(mdmCustomerMsgReqVo);
        mdmCustomerMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        SfaCustomerMsgEntity sfaCustomerMsgEntity = CrmBeanUtil.copy(mdmCustomerMsgReqVo, SfaCustomerMsgEntity.class);
        //保存审批信息到sfa终端表
        this.saveOrUpdate(sfaCustomerMsgEntity);
        //保存联系人和对接人信息
        saveSfaCustomerEntity(mdmCustomerMsgReqVo, sfaCustomerMsgEntity);
        sfaCustomerMsgEntity.setCustomerFormNo(sfaCustomerMsgEntity.getId());
        //提交审批并保存流程编码
        String processNo = ActivityUtils.startProcess(createCustomerStartProcessReqVo(sfaCustomerMsgEntity.getCustomerFormNo()));
        sfaCustomerMsgEntity.setProcessNo(processNo);
        this.saveOrUpdate(sfaCustomerMsgEntity);
    }

    /**
     * 更新审批状态
     *
     * @param activitiCallBackVo 审批回调Vo
     * @return void
     * @method updateActApproveStatus
     * @date: 2021/1/5 15:07
     * @author: YuanZiJian
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateActApproveStatus(ActivitiCallBackVo activitiCallBackVo) {
        if (activitiCallBackVo.getProcessState() == 3) {
            //审批驳回-修改状态为驳回状态
            this.update(new SfaCustomerMsgEntity().setActApproveStatus(ActApproveStatusEnum.REJECTED.getCode())
                    , Wrappers.lambdaUpdate(SfaCustomerMsgEntity.class).eq(SfaCustomerMsgEntity::getCustomerFormNo, activitiCallBackVo.getFormNo()));
        } else if (activitiCallBackVo.getProcessState() == 2) {
            //审批通过
            SfaCustomerMsgEntity sfaCustomerMsgEntity = this.getOne(Wrappers.lambdaQuery(SfaCustomerMsgEntity.class).eq(SfaCustomerMsgEntity::getCustomerFormNo, activitiCallBackVo.getFormNo()));
            sfaCustomerMsgEntity.setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
            this.update(new SfaCustomerMsgEntity().setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode())
                    , Wrappers.lambdaUpdate(SfaCustomerMsgEntity.class).eq(SfaCustomerMsgEntity::getCustomerFormNo, activitiCallBackVo.getFormNo()));
            MdmCustomerMsgReqVo mdmCustomerMsgReqVo = CrmBeanUtil.copy(sfaCustomerMsgEntity, MdmCustomerMsgReqVo.class);
            getMdmCustomerMsgReqVo(mdmCustomerMsgReqVo,sfaCustomerMsgEntity);
            updateCustomerEnd(mdmCustomerMsgReqVo,activitiCallBackVo);
        }
    }

    /**
     * 查询所有在sfa审核表中的经销商数据-小程序端
     *
     * @param sfaCustomerReqVo 查询参数
     * @method findAllTerminal
     * @date: 2021/1/6 10:27
     * @author: YuanZiJian
     */
    @Override
    public PageResult<MdmCustomerMsgReqVo> findAllSfaCustomer(SfaCustomerReqVo sfaCustomerReqVo) {
        //构造条件构造器
        LambdaQueryWrapper<SfaCustomerMsgEntity> lambdaQueryWrapper = getCustomerWrapper(sfaCustomerReqVo);
        Page<SfaCustomerMsgEntity> page = new Page<>(sfaCustomerReqVo.getPageNum(), sfaCustomerReqVo.getPageSize());
        //分页查询
        Page<SfaCustomerMsgEntity> result = this.page(page, lambdaQueryWrapper);
        List<SfaCustomerMsgEntity> sfaCustomerEntities = result.getRecords();
        //SfaCustomerMsgEntity转换为MdmCustomerMsgReqVo
        List<MdmCustomerMsgReqVo> mdmCustomerMsgVoList = new ArrayList<>();
        sfaCustomerEntities.stream().forEach(data ->
                {
                    MdmCustomerMsgReqVo mdmCustomerMsgReqVo = CrmBeanUtil.copy(data, MdmCustomerMsgReqVo.class);
                    getMdmCustomerMsgReqVo(mdmCustomerMsgReqVo, data);
                    mdmCustomerMsgVoList.add(mdmCustomerMsgReqVo);
                }
        );
        return PageResult.<MdmCustomerMsgReqVo>builder()
                .data(mdmCustomerMsgVoList)
                .count(page.getTotal())
                .build();
    }

    /**
     * 更新经销商审批状态——小程序端
     *
     * @param id               经销商id
     * @param remark           审批备注
     * @param actApproveStatus 审批状态
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSfaActApproveStatus(String id, String remark, String actApproveStatus) {
        if (StringUtils.isEmpty(id)) {
            throw new BusinessException("sfa经销商编码Id为空");
        }
        if (StringUtils.isEmpty(actApproveStatus)) {
            throw new BusinessException("sfa经销商审批状态为空");
        }
        SfaCustomerMsgEntity sfaCustomerMsgEntity = this.getOne(Wrappers.lambdaQuery(SfaCustomerMsgEntity.class).eq(SfaCustomerMsgEntity::getId, id));
        if(sfaCustomerMsgEntity==null){
            throw new BusinessException("数据库不存在该终端");
        }
        sfaCustomerMsgEntity.setActRemarks(remark);
        //判断是否有权限审批
        List<TaskRspVO> taskRspVO = getTaskRspVO().stream().filter(data ->
                sfaCustomerMsgEntity.getCustomerFormNo().equals(data.getFormNo())).collect(Collectors.toList());
        if(0==taskRspVO.size()){
            throw new BusinessException("当前职位暂无权限审批");
        }
        //判断是驳回操作还是通过操作
        if (ActApproveStatusEnum.REJECTED.getCode().equals(actApproveStatus)) {
            //驳回
            sfaCustomerMsgEntity.setActApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            //更新工作流的状态为驳回
            mobileFeign.taskReject(new TaskOptReqVO().setOptBtnCode(ActivitiEnum.OperationType.REJECT.getVal()).setTaskId(taskRspVO.get(0).getTaskId()));
        } else {
            //通过
            sfaCustomerMsgEntity.setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
            //更新工作流的状态为通过
            mobileFeign.taskComplete(new TaskOptReqVO().setOptBtnCode(ActivitiEnum.OperationType.ISSUE.getVal()).setTaskId(taskRspVO.get(0).getTaskId()));
        }
        this.saveOrUpdate(sfaCustomerMsgEntity);
    }

    /**
     * 根据id获取审批经销商的信息-小程序端
     *
     * @param id 经销商id
     * @method querySfaTerminalVo
     * @date: 2021/1/6 13:48
     * @author: YuanZiJian
     */
    @Override
    public Result<SfaCustomerMsgRespVo> querySfaCustomerVo(String id) {
        if(StringUtils.isEmpty(id)){
            throw  new BusinessException("审批经销商Id为空");
        }
        SfaCustomerMsgEntity sfaCustomerMsgEntity = this.getOne(Wrappers.lambdaQuery(SfaCustomerMsgEntity.class).eq(SfaCustomerMsgEntity::getId, id));
        AssertUtils.isNotNull(sfaCustomerMsgEntity,"不存在对应经销商");
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = CrmBeanUtil.copy(sfaCustomerMsgEntity,MdmCustomerMsgReqVo.class);
        getMdmCustomerMsgReqVo(mdmCustomerMsgReqVo, sfaCustomerMsgEntity);
        SfaCustomerMsgRespVo sfaCustomerMsgRespVo = CrmBeanUtil.copy(mdmCustomerMsgReqVo, SfaCustomerMsgRespVo.class);
        sfaCustomerMsgRespVo.setChannel(getChannelName(sfaCustomerMsgRespVo.getChannel()));
        if(StringUtils.isNotEmpty(sfaCustomerMsgRespVo.getCustomerOrgCode())){
            CusOrgVo cusOrgVo = ApiResultUtil.objResult(mdmCusOrgFeign.query(null,sfaCustomerMsgRespVo.getCustomerOrgCode()),true);
            if(cusOrgVo==null){
                throw  new BusinessException("客户组织编码不存在[" + sfaCustomerMsgRespVo.getCustomerOrgCode() + "]");
            }
            sfaCustomerMsgRespVo.setCustomerOrgName(cusOrgVo.getCustomerOrgName());
        }
        if(StringUtils.isNotEmpty(sfaCustomerMsgRespVo.getOrgCode())){
            MdmOrgRespVo mdmOrgRespVo = ApiResultUtil.objResult(mdmOrgFeign.detail(null,sfaCustomerMsgRespVo.getOrgCode()),true);
            if(mdmOrgRespVo == null){
                throw  new BusinessException("所属组织编码不存在[" + sfaCustomerMsgRespVo.getOrgCode() + "]");
            }
            sfaCustomerMsgRespVo.setOrgName(mdmOrgRespVo.getOrgName());
        }
        return Result.ok(sfaCustomerMsgRespVo);
    }

    /**
     * 待处理的经销商审批信息数量getMdmCustomerMsgReqVo
     *
     * @return com.biz.crm.util.Result<java.lang.Integer>
     * @method countCustomer
     * @date: 2021/1/6 18:19
     * @author: YuanZiJian
     */
    @Override
    public Result<Integer> countCustomer() {
        int count = 0;
        List<String> formNoList = getTaskRspVO().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(formNoList)){
            return Result.ok(count);
        }
        count = this.count(Wrappers.lambdaQuery(SfaCustomerMsgEntity.class)
                .ne(SfaCustomerMsgEntity::getDelFlag, CrmDelFlagEnum.DELETE)
                .eq(SfaCustomerMsgEntity::getActApproveStatus, ActApproveStatusEnum.APPROVING)
                .in(SfaCustomerMsgEntity::getCustomerFormNo,formNoList));
        return Result.ok(count);
    }

    /**
     * mdmCustomerMsgReqVo字段校验
     *
     * @param mdmCustomerMsgReqVo
     * @return void
     * @method checkVo
     * @date: 2020/12/30 10:28
     * @author: YuanZiJian
     */
    private void checkVo(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (mdmCustomerMsgReqVo == null) {
            throw new BusinessException("参数不正确");
        }
        if (StringUtils.isEmpty(mdmCustomerMsgReqVo.getCustomerName())) {
            throw new BusinessException("经销商名字不能为空");
        }
        if (StringUtils.isEmpty(mdmCustomerMsgReqVo.getCustomerType())) {
            throw new BusinessException("客户类型不能为空");
        }
        if (StringUtils.isEmpty(mdmCustomerMsgReqVo.getOrgCode())) {
            throw new BusinessException("所属组织不能为空");
        }
//        if (StringUtils.isEmpty(mdmCustomerMsgReqVo.getChannel())) {
//            throw new BusinessException("渠道名字不能为空");
//        }
    }


    /**
     * List 非空校验
     *
     * @param list
     * @return boolean
     * @method checkList
     * @date: 2021/1/4 11:29
     * @author: YuanZiJian
     */
    private boolean checkList(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        return true;
    }

    /**
     * 封装实体字段： 联系人 ， 对接人 ， 销售区域
     * mdmCustomerMsgReqVo转sfaCustomerMsgEntity
     * @param mdmCustomerMsgReqVo
     * @param sfaCustomerMsgEntity
     * @return void
     * @method getSfaCustomerEntity
     * @date: 2021/1/4 11:32
     * @author: YuanZiJian
     */
    private void saveSfaCustomerEntity(MdmCustomerMsgReqVo mdmCustomerMsgReqVo, SfaCustomerMsgEntity sfaCustomerMsgEntity) {
        //删除原来的
        sfaContactService.remove(Wrappers.lambdaQuery(SfaContactEntity.class).eq(SfaContactEntity::getClientId,sfaCustomerMsgEntity.getId()).eq(SfaContactEntity::getType, ClientEnum.clientType.CUSTOMER.getValue()));
        sfaDockingService.remove(Wrappers.lambdaQuery(SfaDockingEntity.class).eq(SfaDockingEntity::getCustomerId,sfaCustomerMsgEntity.getId()));
        //保存更新的
        List<MdmCustomerDockingReqVo> mdmCustomerDockingVos = mdmCustomerMsgReqVo.getMdmCustomerDockingVos();
        List<MdmCustomerContactReqVo> mdmCustomerContactVos = mdmCustomerMsgReqVo.getMdmCustomerContactVos();
        //设置联系人所属类型
        List<SfaContactEntity> sfaContactEntities = CrmBeanUtil.copyList(mdmCustomerContactVos, SfaContactEntity.class);
        sfaContactEntities.stream().forEach(data->data.setType(ClientEnum.clientType.CUSTOMER.getValue()).setClientId(sfaCustomerMsgEntity.getId()));
        List<SfaDockingEntity> sfaDockingEntities = CrmBeanUtil.copyList(mdmCustomerDockingVos, SfaDockingEntity.class);
        sfaDockingEntities.forEach(data->data.setCustomerId(sfaCustomerMsgEntity.getId()));
        sfaContactService.saveBatch(sfaContactEntities);
        sfaDockingService.saveBatch(sfaDockingEntities);
    }


    /**
     * 封装VO字段： 联系人 ， 对接人 ， 销售区域，客户编码，组织编码。
     * sfaCustomerMsgEntity转mdmCustomerMsgReqVo
     * @method getMdmCustomerMsgReqVo
     * @date: 2021/1/5 15:25
     * @author: YuanZiJian
     * @param mdmCustomerMsgReqVo
     * @param sfaCustomerMsgEntity
     * @return void
     */
    private void getMdmCustomerMsgReqVo(MdmCustomerMsgReqVo mdmCustomerMsgReqVo, SfaCustomerMsgEntity sfaCustomerMsgEntity) {
        AssertUtils.isNotNull(mdmCustomerMsgReqVo,"");
        //封装——联系人列表
        List<SfaContactEntity> sfaContactEntities = sfaContactService.list(Wrappers.lambdaQuery(SfaContactEntity.class)
                .eq(SfaContactEntity::getClientId, sfaCustomerMsgEntity.getId())
                .eq(SfaContactEntity::getType,ClientEnum.clientType.CUSTOMER.getValue()));
        List<MdmCustomerContactReqVo> mdmCustomerContactReqVos = CrmBeanUtil.copyList(sfaContactEntities, MdmCustomerContactReqVo.class);
        mdmCustomerMsgReqVo.setMdmCustomerContactVos(mdmCustomerContactReqVos);
        //封装——对接人列表
        List<SfaDockingEntity> sfaDockingEntities = sfaDockingService.list(Wrappers.lambdaQuery(SfaDockingEntity.class)
                .eq(SfaDockingEntity::getCustomerId, sfaCustomerMsgEntity.getId()));
        List<MdmCustomerDockingReqVo> mdmCustomerDockingReqVos = CrmBeanUtil.copyList(sfaDockingEntities, MdmCustomerDockingReqVo.class);
        mdmCustomerMsgReqVo.setMdmCustomerDockingVos(mdmCustomerDockingReqVos);
    }
    /**
     * 经销商流程审批Vo创建
     *
     * @param formNo 表单ID——FormNo
     * @return com.biz.crm.nebular.activiti.act.req.StartProcessReqVo
     * @method createCustomerStartProcessReqVo
     * @date: 2021/1/4 17:06
     * @author: YuanZiJian
     */
    private StartProcessReqVo createCustomerStartProcessReqVo(String formNo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo process = new StartProcessReqVo();
        /*
         * 流程实体必填项
         * 1.用户编码（userCode) 发起流程的用户账号名
         * 2.岗位编码（posCode）发起流程的用户岗位
         * 3.流程Key（processKey） 发起流程的流程Key，到流程绘制中添加流程
         * 4.业务单号（formNo)
         * 5.表单标题（title）
         * 6.表单URL（formUrl)
         * 7.回调方法的feign(callBackFeign）流程调用的回调接口
         * 8.防重复验证码
         */
        process.setUserCode(user.getUsername());
        process.setPosCode(user.getPoscode());
        // 通过数据字段获取流程key信息,这里需要新建枚举值
        String processKey = null;
        Map<String, String> map = DictUtil.getDictValueMapsByCodes("customer_activity_keys");
        if (map == null) {
            throw new BusinessException("请配置<数据字典>:customer_activity_keys");
        }
        processKey = map.get(ActivitiEnum.FormTypeEnum.CUSTOMER.getProcessKey());
        if (StringUtils.isEmpty(processKey)) {
            throw new BusinessException("请在数据字典-customer_activity_keys-中添加字典");
        }
        process.setProcessKey(processKey);
        process.setTitle(ActivitiEnum.FormTypeEnum.CUSTOMER.getTitle());
        process.setFormUrl("https");
        process.setFormNo(formNo);
        process.setCallBackFeign(ActivitiEnum.FormTypeEnum.CUSTOMER.getCallBackFeign());
        process.setCostType(ActivitiEnum.FormTypeEnum.CUSTOMER.getCostType());
        process.setSignTicket(UUIDGenerator.generate());
        return process;
    }

    /**
     * 经销商审批流结束回调操作
     * @method updateCustomerEnd
     * @date: 2021/1/5 16:03
     * @author: YuanZiJian
     * @param mdmCustomerMsgReqVo
     * @return void
     */
    private void updateCustomerEnd(MdmCustomerMsgReqVo mdmCustomerMsgReqVo,ActivitiCallBackVo activitiCallBackVo){
        mdmCustomerMsgReqVo.setId(null);
        //联系人判空校验
        if(CollectionUtil.listNotEmpty(mdmCustomerMsgReqVo.getMdmCustomerContactVos())){
            mdmCustomerMsgReqVo.getMdmCustomerContactVos().stream().forEach(data->data.setUpdateDate(null));
            mdmCustomerMsgReqVo.getMdmCustomerContactVos().get(0).setContactMain("1");
        }
        if(StringUtils.isEmpty(mdmCustomerMsgReqVo.getCustomerCode())){
            Result<MdmCustomerMsgRespVo> result = mdmCustomerMsgFeign.save(mdmCustomerMsgReqVo);
            if(result.getCode() != 200){
                throw new BusinessException("审批通过失败");
            }
            //创建人的username/orgCode
            MdmCustomerMsgRespVo mdmCustomerMsgRespVo = result.getResult();
            mdmCustomerMsgReqVo.setId(mdmCustomerMsgRespVo.getId());
            mdmCustomerMsgReqVo.setCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
            this.findRecord(mdmCustomerMsgReqVo);
            //增加积分
            SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
            integralDetailAddReq.setBizId(mdmCustomerMsgRespVo.getId());
            integralDetailAddReq.setIntegralTaskType(IntegralEnum.taskType.SAVE_TERMINAL.getValue());
            integralDetailAddReq.setPosCode(mdmCustomerMsgReqVo.getCreatePosCode());
            integralDetailAddReq.setUserName(mdmCustomerMsgReqVo.getCreateName());
            SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
        }else {
            if(mdmCustomerMsgFeign.update(mdmCustomerMsgReqVo).getCode()!=200){
                throw new BusinessException("审批通过失败");
            }
        }
    }

    /**
     * 审批通过时写入绩效表，查询为空，为新增写入绩效，反之为修改，改变记录的状态
     */
   private void findRecord(MdmCustomerMsgReqVo mdmCustomerMsgReqVo){
        SfaAchievementAccomplishRecordEntity one = this.sfaAchievementAccomplishRecordService.getOne(Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
                .eq(SfaAchievementAccomplishRecordEntity::getRelationId, mdmCustomerMsgReqVo.getId()));
        if (ObjectUtils.isEmpty(one)){
            SfaAchievementAccomplishRecordReqVo reqVo = new SfaAchievementAccomplishRecordReqVo();
            reqVo.setCustomerCode(mdmCustomerMsgReqVo.getCustomerCode())
                    .setRelationId(mdmCustomerMsgReqVo.getId())
                    .setIndexCode(SfaVisitEnum.indexType.XZWD.getCode())
                    .setUsername(mdmCustomerMsgReqVo.getCreateCode())
                    .setCreateTime(mdmCustomerMsgReqVo.getCreateDateAll())
                    .setObjectPosCode(mdmCustomerMsgReqVo.getCreatePosCode())
                    .setCreateOrgCode(mdmCustomerMsgReqVo.getCreateOrgCode());
            AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo);
        }else {
            this.sfaAchievementAccomplishRecordService.reuseByRelationId(mdmCustomerMsgReqVo.getId());
        }
    }
    /**
     * 获取TaskRspVO 工作待办事项
     * @return
     */
    private  List<TaskRspVO>  getTaskRspVO(){
        UserRedis user = UserUtils.getUser();
        TaskQueryReqVO taskQueryReqVO = new TaskQueryReqVO();
        taskQueryReqVO.setUserCode(user.getUsername()).setPositionCode(user.getPoscode());
        taskQueryReqVO.setPageSize(200);
        Result<PageResult<TaskRspVO>> currentTask = mobileFeign.findCurrentTask(taskQueryReqVO);
        List<TaskRspVO> data = currentTask.getResult().getData();
        return data;
    }

    /**
     * 获取TaskRspVO 工作已办事项
     * @method getTaskRespVoDone
     * @date: 2021/1/26 11:36
     * @author: YuanZiJian
     * @return java.util.List<com.biz.crm.nebular.activiti.task.resp.TaskRspVO>
     */
    private List<TaskRspVO> getTaskRespVoDone(){
        UserRedis user = UserUtils.getUser();
        TaskQueryReqVO taskQueryReqVO = new TaskQueryReqVO();
        taskQueryReqVO.setUserCode(user.getUsername()).setPositionCode(user.getPoscode());
        taskQueryReqVO.setPageSize(200);
        Result<PageResult<TaskRspVO>> currentTask = mobileFeign.findDoneTask(taskQueryReqVO);
        List<TaskRspVO> data = currentTask.getResult().getData();
        return data;
    }

    /**
     * 构造条件构造器
     * @method getCustomerWrapper
     * @date: 2021/1/6 17:24
     * @author: YuanZiJian
     * @param sfaCustomerReqVo
     * @return com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper<com.biz.crm.moblie.model.SfaTerminalEntity>
     */
    private LambdaQueryWrapper<SfaCustomerMsgEntity> getCustomerWrapper(SfaCustomerReqVo sfaCustomerReqVo){
        //构造条件构造器-预先添加必须条件
        LambdaQueryWrapper<SfaCustomerMsgEntity> lambdaQueryWrapper = Wrappers.lambdaQuery(SfaCustomerMsgEntity.class);
        lambdaQueryWrapper.ne(SfaCustomerMsgEntity::getDelFlag, CrmDelFlagEnum.DELETE.getCode());
        lambdaQueryWrapper.orderByDesc(SfaCustomerMsgEntity::getCreateDate);
        //设置审核状态查询条件
        if(StringUtils.isEmpty(sfaCustomerReqVo.getActApproveStatus())){
            List<String> formNoList = getTaskRespVoDone().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
            lambdaQueryWrapper.in(SfaCustomerMsgEntity::getCustomerFormNo,formNoList);
            lambdaQueryWrapper.ne(SfaCustomerMsgEntity::getActApproveStatus,ActApproveStatusEnum.APPROVING.getCode());
        }else {
            List<String> formNoList = getTaskRspVO().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
            lambdaQueryWrapper.in(SfaCustomerMsgEntity::getCustomerFormNo,formNoList);
        }
        //设置时间条件、设置根据终端名查询条件
        if(StringUtils.isNotEmpty(sfaCustomerReqVo.getStartTime())&&StringUtils.isNotEmpty(sfaCustomerReqVo.getEndTime())){
            lambdaQueryWrapper.between(SfaCustomerMsgEntity::getCreateDate, sfaCustomerReqVo.getStartTime(), sfaCustomerReqVo.getEndTime());
        }
        if (StringUtils.isNotEmpty(sfaCustomerReqVo.getCustomerName())){
            lambdaQueryWrapper.like(SfaCustomerMsgEntity::getCustomerName, sfaCustomerReqVo.getCustomerName());
        }
        return lambdaQueryWrapper;
    }

    /**
     * 获取渠道名字
     * 获取失败就会返回原数据channel
     * @method getChannelName
     * @date: 2021/1/15 16:23
     * @author: YuanZiJian
     * @param channel
     * @return java.lang.String
     */
    private String getChannelName(String channel){
        if(ChannelEnum.COMMERCE.getCode().equals(channel)){
            return ChannelEnum.COMMERCE.getValue();
        }
        if(ChannelEnum.MODERN.getCode().equals(channel)){
            return ChannelEnum.MODERN.getValue();
        }
        if(ChannelEnum.SPECIAL.getCode().equals(channel)){
            return ChannelEnum.SPECIAL.getValue();
        }
        if(ChannelEnum.TRADIE.getCode().equals(channel)){
            return ChannelEnum.TRADIE.getValue();
        }
        return channel;
    }

    /**
     * 获取客户新增数
     * dateFlag :1.今日 2.本周 3.本月
     */
    @Override
    public Integer getCustomerNum(String dateFlag){
        AssertUtils.isNotEmpty(dateFlag,"请传入查询时间范围类型——本日、本周、本月");
        UserRedis user = UserUtils.getUser();
        LocalDate nowTime = LocalDate.now();
        LambdaQueryWrapper<SfaAchievementAccomplishRecordEntity> queryWrapper = Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
                .eq(SfaAchievementAccomplishRecordEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .eq(SfaAchievementAccomplishRecordEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .eq(SfaAchievementAccomplishRecordEntity::getIndexCode, SfaVisitEnum.indexType.XZWD.getCode())
                .eq(SfaAchievementAccomplishRecordEntity::getUsername,user.getUsername());
        //今日
        if(SfaWorkSummaryEnum.dateFlag.TODAY.getCode().equals(dateFlag)){
            String dayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.eq(SfaAchievementAccomplishRecordEntity::getCreateDate , dayTime);
        }
        //本周
        if(SfaWorkSummaryEnum.dateFlag.WEEK.getCode().equals(dateFlag)){
            //本周第一天
            String weekTime = nowTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).format(CrmDateUtils.yyyyMMdd);
            //当前日期
            String nowDayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.between(SfaAchievementAccomplishRecordEntity::getCreateDate,weekTime,nowDayTime);
        }
        //本月
        if(SfaWorkSummaryEnum.dateFlag.MONTH.getCode().equals(dateFlag)){
            String monthTime = nowTime.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            queryWrapper.like(SfaAchievementAccomplishRecordEntity::getCreateDate , monthTime);
        }
        int count = sfaAchievementAccomplishRecordService.count(queryWrapper);
        return count;
    }

    @Override
    public void countAchievementAndIntegral(MdmCustomerMsgRespVo mdmCustomerMsgRespVo, String fromType) {
        if (StringUtils.isEmpty(fromType)){
            log.info("绩效新增失败，fromType为空");
            return;
        }
        //新增成功，根据数据字典配的数据来源，添加绩效
        Map<String, String> stringStringMap = DictUtil.dictMap("from_type");
        if (ObjectUtils.isEmpty(stringStringMap)){
            log.info("绩效新增失败，未获取到数据字典");
            return;
        }
        List<String> stringList = stringStringMap.values().stream().collect(Collectors.toList());
        if (stringList.contains(fromType)){
            MdmCustomerMsgReqVo vo = CrmBeanUtil.copy(mdmCustomerMsgRespVo, MdmCustomerMsgReqVo.class);
            if (ObjectUtils.isEmpty(vo)){
                log.info("绩效新增失败，未获取到mdm新增客户信息");
            }
            this.findRecord(vo);
            //增加积分
            SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
            integralDetailAddReq.setBizId(vo.getId());
            integralDetailAddReq.setIntegralTaskType(IntegralEnum.taskType.SAVE_TERMINAL.getValue());
            integralDetailAddReq.setPosCode(vo.getCreatePosCode());
            integralDetailAddReq.setUserName(vo.getCreateName());
            SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
        }
    }

}
