package com.biz.crm.moblie.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.sfa.ClientEnum;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.mapper.SfaTerminalMapper;
import com.biz.crm.moblie.model.*;
import com.biz.crm.moblie.service.SfaContactService;
import com.biz.crm.moblie.service.SfaSupplyService;
import com.biz.crm.moblie.service.SfaTerminalService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalMsgReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaTerminalMsgRespVo;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 对终端操作的接口
 *
 * @author YuanZiJian
 * @date 2020/12/29 15:47
 * @version: V1.0
 */
@Service
@Slf4j
public class SfaTerminalServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaTerminalMapper, SfaTerminalEntity> implements SfaTerminalService {

    @Autowired
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private SfaContactService sfaContactService;
    @Autowired
    private SfaSupplyService sfaSupplyService;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;

    /**
     * 查询终端列表
     * 默认查询登陆用户的职位及其下级职位的所有终端
     *
     * @return com.biz.crm.util.Result<java.util.List < com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     * @method findTerminal
     * @date: 2020/12/29 15:48
     * @author: YuanZiJian
     */
    @Override
    public Result<List<MdmTerminalVo>> findTerminal() {
        Result<List<MdmTerminalVo>> currentAndSybPositionTerminalList = mdmTerminalFeign.findCurrentAndSybPositionTerminalList(null, UserUtils.getUser().getPoscode());
        return currentAndSybPositionTerminalList;
    }

    /**
     * 新增终端
     * 存在sfa这里
     * 会先走审批流程
     *
     * @param sfaTerminalMsgReqVo 终端实体
     * @return void
     * @method saveTerminal
     * @date: 2020/12/30 10:18
     * @author: YuanZiJian
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveTerminal(SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        checkVo(sfaTerminalMsgReqVo);
        //手动封装业务员——对接人信息
        List<MdmTerminalSupplyVo> supplys = sfaTerminalMsgReqVo.getSupplys();
        UserRedis user = UserUtils.getUser();
        supplys.forEach(data->{
            data.setFullName(user.getRealname());
            data.setPositionCode(user.getPoscode());
            data.setPositionName(user.getPosname());
        });
        sfaTerminalMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        SfaTerminalEntity terminalEntity = CrmBeanUtil.copy(sfaTerminalMsgReqVo, SfaTerminalEntity.class);
        //保存审批信息到sfa终端表
        this.save(terminalEntity);
        saveSfaTerminalEntity(terminalEntity, sfaTerminalMsgReqVo);
        terminalEntity.setFormNo(terminalEntity.getId());
        //提交审批
        String processNo = ActivityUtils.startProcess(createTerminalStartProcessReqVo(terminalEntity.getFormNo()));
        //获取返回的流程编码
        terminalEntity.setProcessNo(processNo);
        this.saveOrUpdate(terminalEntity);
    }

    /**
     * 更新终端_更新同样需要存到审批中
     *
     * @param sfaTerminalMsgReqVo
     * @return void
     * @method updateTerminal
     * @date: 2020/12/30 10:36
     * @author: YuanZiJian
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateTerminal(SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        checkVo(sfaTerminalMsgReqVo);
        //手动封装业务员——对接人信息
        List<MdmTerminalSupplyVo> supplys = sfaTerminalMsgReqVo.getSupplys();
        UserRedis user = UserUtils.getUser();
        supplys.forEach(data->{
            data.setFullName(user.getRealname());
            data.setPositionCode(user.getPoscode());
            data.setPositionName(user.getPosname());
        });
        if (StringUtils.isEmpty(sfaTerminalMsgReqVo.getId())){
            throw  new BusinessException("请传入对应Id");
        }
        //获取相关的审批信息
        SfaTerminalEntity entity = this.getOne(Wrappers.lambdaQuery(SfaTerminalEntity.class).eq(SfaTerminalEntity::getId, sfaTerminalMsgReqVo.getId()));
        if(entity==null){
            throw  new BusinessException("不存在对应的审批信息");
        }
        if(ActApproveStatusEnum.APPROVING.getCode().equals(entity.getActApproveStatus())){
            throw new BusinessException("该任务正在审批，请等待审批结束，再提交");
        }
        //重新设置为审批中
        sfaTerminalMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        SfaTerminalEntity terminalEntity = CrmBeanUtil.copy(sfaTerminalMsgReqVo, SfaTerminalEntity.class);
        saveSfaTerminalEntity(terminalEntity, sfaTerminalMsgReqVo);
        terminalEntity.setFormNo(terminalEntity.getId());
        //提交审批
        String processNo = ActivityUtils.startProcess(createTerminalStartProcessReqVo(terminalEntity.getFormNo()));
        //获取返回的流程编码
        terminalEntity.setProcessNo(processNo);
    }

    /**
     * 审批流程结束更新审批状态
     *
     * @param activitiCallBackVo 审批状态
     * @return void
     * @method updateActApproveStatus
     * @date: 2021/1/5 15:07
     * @author: YuanZiJian
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateActApproveStatus(ActivitiCallBackVo activitiCallBackVo) {
        if (activitiCallBackVo.getProcessState() == 3) {
            //审批驳回-修改状态为驳回状态
            this.update(new SfaTerminalEntity().setActApproveStatus(ActApproveStatusEnum.REJECTED.getCode())
                    , Wrappers.lambdaUpdate(SfaTerminalEntity.class).eq(SfaTerminalEntity::getId, activitiCallBackVo.getFormNo()));
        } else if (activitiCallBackVo.getProcessState() == 2) {
            //审批通过——获取保存的审批信息
            SfaTerminalEntity sfaTerminalEntity = this.getOne(Wrappers.lambdaQuery(SfaTerminalEntity.class).eq(SfaTerminalEntity::getId, activitiCallBackVo.getFormNo()));
            sfaTerminalEntity.setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
            //审批驳回-修改状态为通过状态
            this.update(new SfaTerminalEntity().setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode())
                    , Wrappers.lambdaUpdate(SfaTerminalEntity.class).eq(SfaTerminalEntity::getId, activitiCallBackVo.getFormNo()));
            MdmTerminalVo mdmTerminalVo = CrmBeanUtil.copy(sfaTerminalEntity, MdmTerminalVo.class);
            getMdmTerminalVo(mdmTerminalVo, sfaTerminalEntity);
            //审批通过——修改审批状态提交保存的审批信息
            updateTerminalEnd(mdmTerminalVo, activitiCallBackVo);
        }
    }

    /**
     * 查询所有在sfa审核表中的终端数据-小程序端
     *
     * @param sfaTerminalReqVo sfa终端审批查询 Vo
     * @return com.biz.crm.util.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     * @method findAllTerminal
     * @date: 2021/1/6 10:27
     * @author: YuanZiJian
     */
    @Override
    public PageResult<SfaTerminalMsgRespVo> findAllSfaTerminal(SfaTerminalReqVo sfaTerminalReqVo) {
        //构造条件构造器
        LambdaQueryWrapper<SfaTerminalEntity> lambdaQueryWrapper = getTerminalWrapper(sfaTerminalReqVo);
        Page<SfaTerminalEntity> page = new Page<>(sfaTerminalReqVo.getPageNum(), sfaTerminalReqVo.getPageSize());
        Page<SfaTerminalEntity> result = this.page(page, lambdaQueryWrapper);
        List<SfaTerminalEntity> sfaTerminalEntities = result.getRecords();
        List<MdmTerminalVo> mdmTerminalVoList = new ArrayList<>();
        sfaTerminalEntities.stream().forEach(data ->
                {
                    MdmTerminalVo mdmTerminalVo = CrmBeanUtil.copy(data, MdmTerminalVo.class);
                    getMdmTerminalVo(mdmTerminalVo, data);
                    mdmTerminalVoList.add(mdmTerminalVo);
                }
        );
        List<SfaTerminalMsgRespVo> sfaTerminalMsgRespVos = CrmBeanUtil.copyList(mdmTerminalVoList, SfaTerminalMsgRespVo.class);
        return PageResult.<SfaTerminalMsgRespVo>builder()
                .data(sfaTerminalMsgRespVos)
                .count(page.getTotal())
                .build();
    }

    /**
     * 更新终端审批状态——小程序端
     *
     * @param id               终端id
     * @param remark           审批备注
     * @param actApproveStatus 审批状态
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSfaActApproveStatus(String id, String remark, String actApproveStatus) {
        if (StringUtils.isEmpty(id)) {
            throw new BusinessException("sfa终端编码为空");
        }
        if (StringUtils.isEmpty(actApproveStatus)) {
            throw new BusinessException("终端审批状态为空");
        }
        SfaTerminalEntity sfaTerminalEntity = this.getOne(Wrappers.lambdaQuery(SfaTerminalEntity.class).eq(SfaTerminalEntity::getId, id));
        sfaTerminalEntity.setActRemarks(remark);
        //判断是否有权限审批
        Result<PageResult<TaskRspVO>> resultResult = mobileFeign.findCurrentTask(new TaskQueryReqVO().setFormNo(id));
//        List<TaskRspVO> taskRspVO = getTaskRspVO().stream().filter(data ->
//                sfaTerminalEntity.getFormNo().equals(data.getFormNo())).collect(Collectors.toList());
        if (0 == resultResult.getResult().getCount()) {
            throw new BusinessException("当前职位暂无权限审批");
        }
        sfaTerminalEntity.setActApproveStatus(actApproveStatus);
        this.saveOrUpdate(sfaTerminalEntity);
        TaskRspVO taskRspVO = resultResult.getResult().getData().get(0);
        //判断是驳回操作还是通过操作
        if (ActApproveStatusEnum.REJECTED.getCode().equals(actApproveStatus)) {
            //更新工作流的状态为驳回
            mobileFeign.taskReject(new TaskOptReqVO().setOptBtnCode(ActivitiEnum.OperationType.REJECT.getVal()).setTaskId(taskRspVO.getTaskId()));
        } else {
            //更新工作流的状态通过
            mobileFeign.taskComplete(new TaskOptReqVO().setOptBtnCode(ActivitiEnum.OperationType.ISSUE.getVal()).setTaskId(taskRspVO.getTaskId()));
        }
    }

    /**
     * 根据id获取审批终端的信息-小程序端
     *
     * @param id 终端id
     * @return com.biz.crm.util.Result<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>
     * @method querySfaTerminalVo
     * @date: 2021/1/6 13:48
     * @author: YuanZiJian
     */
    @Override
    public Result<SfaTerminalMsgRespVo> querySfaTerminalVo(String id) {
        if (StringUtils.isEmpty(id)) {
            throw new BusinessException("审批终端Id为空");
        }
        SfaTerminalEntity sfaTerminalEntity = this.getOne(Wrappers.lambdaQuery(SfaTerminalEntity.class).eq(SfaTerminalEntity::getId, id));
        SfaTerminalMsgRespVo mdmTerminalVo = CrmBeanUtil.copy(sfaTerminalEntity, SfaTerminalMsgRespVo.class);
        getSfaTerminalMsgRespVo(mdmTerminalVo, sfaTerminalEntity);
        mdmTerminalVo.setRemarks(sfaTerminalEntity.getActRemarks());
        return Result.ok(mdmTerminalVo);
    }

    /**
     * 待处理的经销商审批信息数量
     *
     * @return com.biz.crm.util.Result<java.lang.Integer>
     * @method countTerminal
     * @date: 2021/1/6 18:19
     * @author: YuanZiJian
     */
    @Override
    public Result<Integer> countTerminal() {
        int count = 0;
        List<String> formNoList = getTaskRspVO().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(formNoList)){
            return Result.ok(count);
        }
        //统计在sfa审批表的和流程中都在审批中的
        count = this.count(Wrappers.lambdaQuery(SfaTerminalEntity.class)
                .ne(SfaTerminalEntity::getDelFlag, CrmDelFlagEnum.DELETE)
                .eq(SfaTerminalEntity::getActApproveStatus, ActApproveStatusEnum.APPROVING)
                .in(SfaTerminalEntity::getFormNo,formNoList));
        return Result.ok(count);
    }

    @Override
    public void countAchievementAndIntegral(MdmTerminalVo mdmTerminalVo, String fromType) {
        if (StringUtils.isEmpty(fromType)){
            log.info("绩效新增失败，fromType为空");
            return;
        }
        //新增成功，根据数据字典配的数据来源，添加绩效
        Map<String, String> stringStringMap = DictUtil.dictMap("from_type");
        if (ObjectUtils.isEmpty(stringStringMap)){
            log.info("绩效新增失败，未获取到数据字典");
            return;
        }
        List<String> stringList = stringStringMap.values().stream().collect(Collectors.toList());
        if (stringList.contains(fromType)){
            MdmTerminalVo vo = CrmBeanUtil.copy(mdmTerminalVo, MdmTerminalVo.class);
            if (ObjectUtils.isEmpty(vo)){
                log.info("绩效新增失败，未获取到mdm新增终端信息");
            }
            this.findRecord(vo);
            //增加积分
            SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
            integralDetailAddReq.setBizId(vo.getId());
            integralDetailAddReq.setIntegralTaskType(IntegralEnum.taskType.SAVE_TERMINAL.getValue());
            integralDetailAddReq.setPosCode(vo.getCreatePosCode());
            integralDetailAddReq.setUserName(vo.getCreateName());
            integralDetailAddReq.setExtParam(null);
            SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
        }
    }


    /**
     * sfaTerminalMsgReqVo字段校验
     *
     * @param sfaTerminalMsgReqVo
     * @return void
     * @method checkVo
     * @date: 2020/12/30 10:28
     * @author: YuanZiJian
     */
    private void checkVo(SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        if (sfaTerminalMsgReqVo == null) {
            throw new BusinessException("参数不正确");
        }
//        if(StringUtils.isEmpty(sfaTerminalMsgReqVo.getAmapId())){
//            throw new BusinessException("AmapId未传");
//        }
//        if (StringUtils.isEmpty(sfaTerminalMsgReqVo.getChannelName())) {
//            throw new BusinessException("渠道名字不能为空");
//        }
    }

    /**
     * 终端流程审批Vo创建
     *
     * @param formNo 表单ID——FormNo
     * @return com.biz.crm.nebular.activiti.act.req.StartProcessReqVo
     * @method createCustomerStartProcessReqVo
     * @date: 2021/1/4 17:06
     * @author: YuanZiJian
     */
    private StartProcessReqVo createTerminalStartProcessReqVo(String formNo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo process = new StartProcessReqVo();
        /*
         * 流程实体必填项
         * 1.用户编码（userCode) 发起流程的用户账号名
         * 2.岗位编码（posCode）发起流程的用户岗位
         * 3.流程Key（processKey） 发起流程的流程Key，到流程绘制中添加流程
         * 4.业务单号（formNo) 保存对象ID
         * 5.表单标题（title）
         * 6.表单URL（formUrl)
         * 7.回调方法的feign(callBackFeign）流程调用的回调接口
         * 8.防重复验证码
         */
        process.setUserCode(user.getUsername());
        process.setPosCode(user.getPoscode());
        // 通过数据字段获取流程key信息,这里需要新建枚举值
        String processKey = null;
        Map<String, String> map = DictUtil.getDictValueMapsByCodes("customer_activity_keys");
        if (map == null) {
            throw new BusinessException("请配置<数据字典>:customer_activity_keys");
        }
        processKey = map.get(ActivitiEnum.FormTypeEnum.TERMINAL.getProcessKey());
        if (StringUtils.isEmpty(processKey)) {
            throw new BusinessException("请在数据字典-customer_activity_keys-中添加字典");
        }
        process.setProcessKey(processKey);
        process.setTitle(ActivitiEnum.FormTypeEnum.TERMINAL.getTitle());
        process.setFormUrl("https");
        process.setFormNo(formNo);
        process.setFormType(ActivitiEnum.FormTypeEnum.TERMINAL.getFormType());
        process.setCostType(ActivitiEnum.FormTypeEnum.TERMINAL.getCostType());
        process.setCallBackFeign(ActivitiEnum.FormTypeEnum.TERMINAL.getCallBackFeign());
        //防重验证码
        process.setSignTicket(UUIDGenerator.generate());
        return process;
    }

    /**
     * 封装VO字段
     * sfaTerminalEntity转mdmTerminalVo
     *
     * @param mdmTerminalVo
     * @param sfaTerminalEntity
     * @return void
     * @method getMdmTerminalVo
     * @date: 2021/1/5 18:15
     * @author: YuanZiJian
     */
    private void getMdmTerminalVo(MdmTerminalVo mdmTerminalVo, SfaTerminalEntity sfaTerminalEntity) {
        //封装——联系人列表
        List<SfaContactEntity> sfaContactEntities = sfaContactService.list(Wrappers.lambdaQuery(SfaContactEntity.class)
                .eq(SfaContactEntity::getClientId, sfaTerminalEntity.getId())
                .eq(SfaContactEntity::getType, ClientEnum.clientType.CUSTOMER.getValue()));
        List<MdmTerminalContactVo> mdmTerminalContactVos = CrmBeanUtil.copyList(sfaContactEntities, MdmTerminalContactVo.class);
        mdmTerminalVo.setContacts(mdmTerminalContactVos);
        //封装——供货关系
        List<SfaSupplyEntity> sfaSupplyEntities = sfaSupplyService.list(Wrappers.lambdaQuery(SfaSupplyEntity.class).eq(SfaSupplyEntity::getTerminalId, sfaTerminalEntity.getId()));
        List<MdmTerminalSupplyVo> mdmTerminalSupplyVos = CrmBeanUtil.copyList(sfaSupplyEntities, MdmTerminalSupplyVo.class);
        mdmTerminalVo.setSupplys(mdmTerminalSupplyVos);
    }

    /**
     *  封装SFA的VO字段
     * @method getSfaTerminalMsgRespVo
     * @date: 2021/3/12 17:42
     * @author: YuanZiJian
     * @param mdmTerminalVo
     * @param sfaTerminalEntity
     * @return void
     */
    private void getSfaTerminalMsgRespVo(SfaTerminalMsgRespVo mdmTerminalVo, SfaTerminalEntity sfaTerminalEntity) {
        //封装——联系人列表
        List<SfaContactEntity> sfaContactEntities = sfaContactService.list(Wrappers.lambdaQuery(SfaContactEntity.class)
                .eq(SfaContactEntity::getClientId, sfaTerminalEntity.getId())
                .eq(SfaContactEntity::getType, ClientEnum.clientType.CUSTOMER.getValue()));
        List<MdmTerminalContactVo> mdmTerminalContactVos = CrmBeanUtil.copyList(sfaContactEntities, MdmTerminalContactVo.class);
        mdmTerminalVo.setContacts(mdmTerminalContactVos);
        //封装——供货关系
        List<SfaSupplyEntity> sfaSupplyEntities = sfaSupplyService.list(Wrappers.lambdaQuery(SfaSupplyEntity.class).eq(SfaSupplyEntity::getTerminalId, sfaTerminalEntity.getId()));
        List<MdmTerminalSupplyVo> mdmTerminalSupplyVos = CrmBeanUtil.copyList(sfaSupplyEntities, MdmTerminalSupplyVo.class);
        mdmTerminalVo.setSupplys(mdmTerminalSupplyVos);
    }

    /**
     * 新增终端到mdm
     *
     * @param mdmTerminalVo
     * @param activitiCallBackVo
     * @return void
     * @method updateTerminalEnd
     * @date: 2021/1/6 10:45
     * @author: YuanZiJian
     */
    private void updateTerminalEnd(MdmTerminalVo mdmTerminalVo, ActivitiCallBackVo activitiCallBackVo) {
        mdmTerminalVo.setId(null);
        //设置主联系人
        if(CollectionUtil.listNotEmpty(mdmTerminalVo.getContacts())){
            mdmTerminalVo.getContacts().get(0).setContactMain("1");
        }
        if (StringUtils.isEmpty(mdmTerminalVo.getTerminalCode())) {
            Result<MdmTerminalVo> result = mdmTerminalFeign.save(mdmTerminalVo);
            if (result.getCode() != 200) {
                throw new BusinessException("审批通过失败——mdm新增失败");
            }
            MdmTerminalVo mdmTerminalResultVo = result.getResult();
            //创建人的username/orgCode
            mdmTerminalVo.setId(mdmTerminalResultVo.getId());
            mdmTerminalVo.setTerminalCode(mdmTerminalResultVo.getTerminalCode());
            this.findRecord(mdmTerminalVo);

            //增加积分
            SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
            integralDetailAddReq.setBizId(mdmTerminalResultVo.getId());
            integralDetailAddReq.setIntegralTaskType(IntegralEnum.taskType.SAVE_TERMINAL.getValue());
            integralDetailAddReq.setPosCode(mdmTerminalVo.getCreatePosCode());
            integralDetailAddReq.setUserName(mdmTerminalVo.getCreateName());
            SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
        } else {
            if (mdmTerminalFeign.update(mdmTerminalVo).getCode() != 200) {
                throw new BusinessException("审批通过失败——mdm更新失败");
            }
        }
    }

    /**
     * 审批通过时写入绩效表，查询为空，为新增写入绩效，反之为修改，改变记录的状态
     */
    void findRecord(MdmTerminalVo mdmTerminalVo){
        SfaAchievementAccomplishRecordEntity one = this.sfaAchievementAccomplishRecordService.getOne(Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
                .eq(SfaAchievementAccomplishRecordEntity::getRelationId, mdmTerminalVo.getId()));
        if (ObjectUtils.isEmpty(one)){
            SfaAchievementAccomplishRecordReqVo reqVo = new SfaAchievementAccomplishRecordReqVo();
            reqVo.setCustomerCode(mdmTerminalVo.getTerminalCode())
                    .setRelationId(mdmTerminalVo.getId())
                    .setIndexCode(SfaVisitEnum.indexType.XZWD.getCode())
                    .setUsername(mdmTerminalVo.getCreateCode())
                    .setCreateTime(mdmTerminalVo.getCreateDateAll())
                    .setObjectPosCode(mdmTerminalVo.getCreatePosCode())
                    .setCreateOrgCode(mdmTerminalVo.getCreateOrgCode());
            AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo);
        }else {
            this.sfaAchievementAccomplishRecordService.reuseByRelationId(mdmTerminalVo.getId());
        }
    }

    /**
     * 获取TaskRspVO 工作待办事项
     *
     * @return
     */
    private List<TaskRspVO> getTaskRspVO() {
        UserRedis user = UserUtils.getUser();
        Result<PageResult<TaskRspVO>> currentTask = mobileFeign.findCurrentTask(new TaskQueryReqVO().setUserCode(user.getUsername()).setPositionCode(user.getPoscode()));
        List<TaskRspVO> data = currentTask.getResult().getData();
        return data;
    }

    private List<TaskRspVO> getTaskRspDoneVo(){
        UserRedis user = UserUtils.getUser();
        Result<PageResult<TaskRspVO>> currentTask = mobileFeign.findDoneTask(new TaskQueryReqVO().setUserCode(user.getUsername()).setPositionCode(user.getPoscode()));
        List<TaskRspVO> data = currentTask.getResult().getData();
        return data;
    }


    /**
     * 构造条件构造器
     *
     * @param sfaTerminalReqVo
     * @return com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper<com.biz.crm.moblie.model.SfaTerminalEntity>
     * @method getTerminalWrapper
     * @date: 2021/1/6 17:24
     * @author: YuanZiJian
     */
    private LambdaQueryWrapper<SfaTerminalEntity> getTerminalWrapper(SfaTerminalReqVo sfaTerminalReqVo) {
        //构造条件构造器
        LambdaQueryWrapper<SfaTerminalEntity> lambdaQueryWrapper = Wrappers.lambdaQuery(SfaTerminalEntity.class);
        lambdaQueryWrapper.ne(SfaTerminalEntity::getDelFlag, CrmDelFlagEnum.DELETE.getCode());
        //设置审核状态查询条件
        if (StringUtils.isEmpty(sfaTerminalReqVo.getActApproveStatus())) {
            List<String> formNoList = getTaskRspDoneVo().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
            lambdaQueryWrapper.in(SfaTerminalEntity::getFormNo,formNoList);
        } else {
            List<String> formNoList = getTaskRspVO().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
            lambdaQueryWrapper.in(SfaTerminalEntity::getFormNo,formNoList);
        }
        //设置终端名字模糊查询条件
        if (StringUtils.isNotEmpty(sfaTerminalReqVo.getTerminalName())) {
            lambdaQueryWrapper.like(SfaTerminalEntity::getTerminalName, sfaTerminalReqVo.getTerminalName());
        }
        //设置时间段查询条件
        if (StringUtils.isNotEmpty(sfaTerminalReqVo.getStartTime()) && StringUtils.isNotEmpty(sfaTerminalReqVo.getEndTime())) {
            lambdaQueryWrapper.between(SfaTerminalEntity::getCreateDate, sfaTerminalReqVo.getStartTime(), sfaTerminalReqVo.getEndTime());
        }
        //设置显示顺序
        lambdaQueryWrapper.orderByDesc(SfaTerminalEntity::getCreateDate);
        return lambdaQueryWrapper;
    }

    /**
     * 封装终端实体
     *
     * @return void
     * @method saveSfaTerminalEntity
     * @date: 2021/1/25 11:17
     * @author: YuanZiJian
     */
    private void saveSfaTerminalEntity(SfaTerminalEntity terminalEntity, SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        //删除原来的
        sfaContactService.remove(Wrappers.lambdaQuery(SfaContactEntity.class).eq(SfaContactEntity::getClientId, terminalEntity.getId()).eq(SfaContactEntity::getType, ClientEnum.clientType.TERMINAL.getValue()));
        sfaSupplyService.remove(Wrappers.lambdaQuery(SfaSupplyEntity.class).eq(SfaSupplyEntity::getTerminalId, terminalEntity.getId()));
        //保存更新的
        List<MdmTerminalContactVo> contacts = sfaTerminalMsgReqVo.getContacts();
        List<MdmTerminalSupplyVo> supplys = sfaTerminalMsgReqVo.getSupplys();
        //设置联系人所属类型
        List<SfaContactEntity> sfaContactEntities = CrmBeanUtil.copyList(contacts, SfaContactEntity.class);
        sfaContactEntities.stream().forEach(data -> data.setType(ClientEnum.clientType.CUSTOMER.getValue()).setClientId(terminalEntity.getId()));
        List<SfaSupplyEntity> sfaSupplyEntities = CrmBeanUtil.copyList(supplys, SfaSupplyEntity.class);
        sfaSupplyEntities.forEach(data -> data.setTerminalId(terminalEntity.getId()));
        sfaContactService.saveBatch(sfaContactEntities);
        sfaSupplyService.saveBatch(sfaSupplyEntities);
    }
}
