package com.biz.crm.moblie.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.moblie.service.ISfaVisitOffLineService;
import com.biz.crm.moblie.visitoffline.SfaVisitOffLineComponent;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductBySfaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductBySfaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOffLineDataVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitStepOffLienVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.google.common.collect.Lists;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.service.impl
 * @date 2021/6/23 15:33
 */
@Service
@ConditionalOnMissingBean(name = "SfaVisitOffLineServiceExpandImpl")
@Slf4j
public class SfaVisitOffLineServiceImpl implements ISfaVisitOffLineService {

    private static final String REDIS_HASH_KEY = "visit_off_line";

    private static final Long REDIS_EXPIRE_TIME = Long.valueOf(60 * 60 * 2);

    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitOffLineComponent sfaVisitOffLineComponent;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmProductLevelFeign mdmProductLevelFeign;

    /**
     * 获取拜访离线数据
     *
     * @param redisHashKeyVo
     * @return
     */
    @Override
    public VisitOffLineDataVo getVisitOffLineData(CrmRedisHashKeyVo redisHashKeyVo) {
        //获取拜访明细数据信息
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKeyVo.getRedisHashKey());
        SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil();
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity) this.redisService.hmget(util.getRedisHashKey(visitRedisHashKey.getVisitBigType()),
                util.getFiled(visitRedisHashKey.getClientCode(), visitRedisHashKey.getVisitBigType()));
        //从redis里取出当前拜访的离线数据
//        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
//        VisitOffLineDataVo dataVo = (VisitOffLineDataVo) redisService.hmget(buildRedisHashKey(REDIS_HASH_KEY, sfaVisitPlanInfoEntity.getId()), sfaVisitPlanInfoEntity.getId() + RedisParam.DELIMITER + now);
        VisitOffLineDataVo dataVo;
        SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData) this.redisService
                .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), redisHashKeyVo.getRedisHashKey());
        //进行数据转换
        dataVo = CrmBeanUtil.copy(doingData.getSfaVisitPlanInfoExecuteRedisData(), VisitOffLineDataVo.class);
        dataVo.setClientPhoto(doingData.getClientPhoto());
        List<VisitStepOffLienVo> stepOffLienVos = CrmBeanUtil.copyList(doingData.getStep(), VisitStepOffLienVo.class);

        List<VisitOfflineReqVo> stepCodeList = stepOffLienVos.stream().map(data -> {
            VisitOfflineReqVo reqVo = VisitOfflineReqVo.builder()
                    .stepCode(data.getStepCode())
                    .visitPlanInfoId(sfaVisitPlanInfoEntity.getId())
                    .clientCode(sfaVisitPlanInfoEntity.getClientCode())
                    .clientType(sfaVisitPlanInfoEntity.getClientType())
                    .formId(data.getFormId())
                    .redisHashKey(redisHashKeyVo.getRedisHashKey())
                    .build();
            return reqVo;
        }).collect(Collectors.toList());
        //多线程执行获取拜访执行的封装数据
        Map<String, Object> stepMap = sfaVisitOffLineComponent.buildVisitStepData(stepCodeList);
        ;
        for (VisitStepOffLienVo data : stepOffLienVos) {
            if (stepMap.containsKey(data.getStepCode())) {
                data.setExecuteData(stepMap.get(data.getStepCode()));
            }
        }
        dataVo.setSteps(stepOffLienVos);
        dataVo.setProductRespVos(this.getProductList());
        dataVo.setProductLevelVoList(this.getProductLevel());
//            redisService.hmset(buildRedisHashKey(REDIS_HASH_KEY, sfaVisitPlanInfoEntity.getId()), buildRedisMap(sfaVisitPlanInfoEntity.getId(), dataVo), REDIS_EXPIRE_TIME);
        return dataVo;
    }

    /**
     * 保存离线数据
     *
     * @param reqVoList
     */
    @Override
    public void saveVisitOffLineData(List<SfaVisitOffLineReqVo> reqVoList) {
        List<SfaVisitOffLineReqVo> dataList = new ArrayList<>();
        reqVoList.forEach(data -> {
            AssertUtils.isNotEmpty(data.getStepCode(), "拜访步骤编码为空");
            if (null != data.getReq()) {
                dataList.add(data);
            }
        });
        String resultMsg = sfaVisitOffLineComponent.saveSfaVisitStepData(dataList);
        if (null != resultMsg && resultMsg.length() > 0) {
            throw new BusinessException(resultMsg);
        }
    }

    /**
     * 离线文件保存
     *
     * @param list
     */
    @Override
    public void saveOffLineFile(List<AttachmentOffLineVo> list) {
        Map<String, List<AttachmentOffLineVo>> fileMap = list.stream().collect(Collectors.groupingBy(AttachmentOffLineVo::getKeyFields));
        sfaVisitOffLineComponent.saveOffLineFile(fileMap);
    }


    private List<MdmProductBySfaRespVo> getProductList() {
        MdmProductBySfaReqVo reqVo = new MdmProductBySfaReqVo();
        reqVo.setPageSize(-1);
        PageResult<MdmProductBySfaRespVo> pageResult = ApiResultUtil.objResult(mdmProductFeign.findProductListSourceSfa(reqVo), true);
        if (null == pageResult) {
            throw new BusinessException("商品为空");
        }
        return pageResult.getData();
    }

    /**
     * 获取所有产品层级以及产品层级下的产品
     *
     * @return
     */
    private List<VisitOffLineDataVo.MdmProductLevelVo> getProductLevel() {
        Result<List<MdmProductLevelRespVo>> result = mdmProductLevelFeign.getAllProductLevelList();
        List<MdmProductLevelRespVo> productLevelRespVoList = ApiResultUtil.objResult(result, result.isSuccess());
        List<VisitOffLineDataVo.MdmProductLevelVo> productLevelOne = productLevelRespVoList.stream()
                .filter(data -> null == data.getParentCode() || ("").equals(data.getParentCode()))
                .map(data -> {
                    VisitOffLineDataVo.MdmProductLevelVo levelVo = CrmBeanUtil.copy(data, VisitOffLineDataVo.MdmProductLevelVo.class);
                    return levelVo;
                }).collect(Collectors.toList());
        Map<String, List<MdmProductLevelRespVo>> levelTwoMap = productLevelRespVoList.stream()
                .filter(data -> StringUtils.isNotEmpty(data.getParentCode()))
                .collect(Collectors.groupingBy(MdmProductLevelRespVo::getParentCode));
        List<String> productLevelCodeList = new ArrayList<>();
        levelTwoMap.entrySet().forEach(data -> {
            final List<String> productLevelCode = data.getValue().stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
            productLevelCodeList.addAll(productLevelCode);
        });
        //查询产品层级下的商品
        Result<List<MdmProductRespVo>> productResult = mdmProductFeign.queryBatchByProductLevelCodeList(productLevelCodeList);
        //通过产品层级进行分组处理
        Map<String, List<MdmProductRespVo>> mdmProductMap = ApiResultUtil.objResult(productResult, productResult.isSuccess())
                .stream().collect(Collectors.groupingBy(MdmProductRespVo::getProductLevelCode));
        productLevelOne.forEach(data -> {
            if (levelTwoMap.containsKey(data.getProductLevelCode())) {
                List<VisitOffLineDataVo.MdmProductLevelVo> levelVoList = CrmBeanUtil.copyList(levelTwoMap.get(data.getProductLevelCode()), VisitOffLineDataVo.MdmProductLevelVo.class);
                levelVoList.forEach(levelTwo -> {
                    List<String> levelCodeList = ProductLevelUtil.getChildrenProductLevelListExcludeSelf(levelTwo.getProductLevelCode())
                            .stream().filter(pd -> null != pd).map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
                    if (!CollectionUtil.listNotEmptyNotSizeZero(levelCodeList)) {
                        levelCodeList = Lists.newArrayList(levelTwo.getProductLevelCode());
                    }
                    List<VisitOffLineDataVo.MdmProductVo> productList = new ArrayList<>();
                    levelCodeList.forEach(levelCode -> {
                        if (mdmProductMap.containsKey(levelCode)) {
                            List<VisitOffLineDataVo.MdmProductVo> pdList = CrmBeanUtil.copyList(mdmProductMap.get(levelCode), VisitOffLineDataVo.MdmProductVo.class);
                            productList.addAll(pdList);
                        }
                    });
                    if (CollectionUtil.listNotEmptyNotSizeZero(productList)) {
                        levelTwo.setProductList(productList);
                    }
                });
                data.setProductLevelList(levelVoList);
            }
        });

        return productLevelOne;
    }

    /**
     * 组装离线数据的redisKey
     *
     * @param redisHashKey
     * @param visitPlanInfoId
     * @return
     */
    private String buildRedisHashKey(String redisHashKey, String visitPlanInfoId) {
        return REDIS_HASH_KEY + RedisParam.DELIMITER + visitPlanInfoId + LocalDate.now().format(CrmDateUtils.yyyyMMdd);
    }

    /**
     * 组装redis map
     *
     * @param visitPlanInfoId
     * @param vo
     * @return
     */
    private Map<String, VisitOffLineDataVo> buildRedisMap(String visitPlanInfoId, VisitOffLineDataVo vo) {
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        Map<String, VisitOffLineDataVo> map = new HashMap<>();
        String key = visitPlanInfoId + RedisParam.DELIMITER + now;
        map.put(key, vo);
        return map;
    }
}
