package com.biz.crm.moblie.visitoffline;

import com.biz.crm.base.BusinessException;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.catalina.User;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.concurrent.*;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.service.impl
 * @date 2021/6/23 16:39
 */
@Component
@ConditionalOnMissingBean(name = "sfaVisitOffLineComponentExpandImpl")
@Slf4j
public class SfaVisitOffLineComponent {

    //核心线程数
    private static final Integer CORE_POOL_SIZE = 30;

    //临时线程数
    private static final Integer MAXIMUM_POOL_SIZE = 50;

    //空闲时间清除临时线程数
    private static final Integer KEEP_ALIVE_TIME = 50;

    private static final Integer SIZE = 2000;

    /**
     * 使用无解的队列方式，避免导致使用人数过多，加载数据失败
     */
    private static final LinkedBlockingQueue<Runnable> QUEUE = new LinkedBlockingQueue<>(SIZE);

    private ThreadPoolExecutor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE_TIME, TimeUnit.SECONDS, QUEUE);

    /**
     * 多线程处理
     *
     * @param reqVos
     * @return
     */
    public Map<String, Object> buildVisitStepData(List<VisitOfflineReqVo> reqVos) {
        Map<String, Object> stepMap = new HashMap<>();
        String token = UserUtils.getToken();
        Future<Map<String, Object>> future = THREAD_POOL_EXECUTOR.submit(() -> {
            UserUtils.setToken(token);
            Map<String, Object> map = new HashMap<>(reqVos.size());
            reqVos.forEach(data -> {
                VisitOfflineReqVo reqVo = VisitOfflineReqVo.builder()
                        .clientCode(data.getClientCode())
                        .clientType(data.getClientType())
                        .stepCode(data.getStepCode())
                        .visitPlanInfoId(data.getVisitPlanInfoId())
                        .formId(data.getFormId())
                        .redisHashKey(data.getRedisHashKey())
                        .build();
                SfaVisitStepOffLineValidator validator = new SfaVisitStepOffLineValidator(data.getStepCode());
                Object obj = validator.buildVisitStepOffLineData(reqVo);
                map.put(data.getStepCode(), obj);
            });
            return map;
        });
        String result = null;
        try {
            stepMap = future.get();
        } catch (InterruptedException e) {
            log.warn("线程异常:{}", e);
            e.printStackTrace();
        } catch (ExecutionException e) {
            log.warn("线程异常:{}", e);
            e.printStackTrace();
        }catch (BusinessException e){
            result = e.getMsg();
        }
        if (null ==stepMap || stepMap.size()==0){
            if (null != result){
                throw new BusinessException(result);
            }else {
                throw new BusinessException("获取离线拜访数据为空");
            }
        }
        return stepMap;
    }


    /**
     * 保存拜访步骤离线数据-data
     *
     * @param dataList
     */
    public String saveSfaVisitStepData(List<SfaVisitOffLineReqVo> dataList) {
        String dataMsg = null;
        String token = UserUtils.getToken();
        Future<String> future = THREAD_POOL_EXECUTOR.submit(() -> {
            UserUtils.setToken(token);
            StringJoiner resultMsg = new StringJoiner(";");
            dataList.forEach(data -> {
                SfaVisitStepOffLineValidator validator = new SfaVisitStepOffLineValidator(data.getStepCode());
                Result result = validator.saveVisitStepOffLine(data.getReq());
                if (!result.isSuccess()) {
                    resultMsg.add(result.getMessage());
                }
            });
            return resultMsg.toString();
        });
        log.info("拜访离线数据提交完成.........");
        try {
            if (null != future.get()) {
                dataMsg = future.get();
            }
        } catch (InterruptedException e) {
            log.warn("提交离线数据异常:{}", e);
            e.printStackTrace();
        } catch (ExecutionException e) {
            log.warn("提交离线数据异常:{}", e);
            e.printStackTrace();
        }
//        StringJoiner resultMsg = new StringJoiner(";");
//        dataList.forEach(data -> {
//            SfaVisitStepOffLineValidator validator = new SfaVisitStepOffLineValidator(data.getStepCode());
//            Result result = validator.saveVisitStepOffLine(data.getReq());
//            if (!result.isSuccess()) {
//                resultMsg.add(result.getMessage());
//            }
//        });
        return dataMsg;
    }


    /**
     * 保存离线数据
     *
     * @param fileMap
     */
    public void saveOffLineFile(Map<String, List<AttachmentOffLineVo>> fileMap) {
        String token = UserUtils.getToken();
        THREAD_POOL_EXECUTOR.execute(() -> {
            UserUtils.setToken(token);
            fileMap.entrySet().forEach(map -> {
                String key = map.getKey();
                SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil(key);
                List<AttachmentOffLineVo> fileList = map.getValue();
                SfaVisitStepOffLineValidator validator = new SfaVisitStepOffLineValidator(util.getStepCode());
                validator.saveVisitStepOffLineFile(fileList, util);
            });
        });

    }
}
