package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.moblie.controller.visit.component.impl.CompetitorVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepComponentVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLinePhotoVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletProductReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletProductRespVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletProductMapper;
import com.biz.crm.visitstep.model.SfaVisitStepColletEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe 竟品采集
 * @project crm
 * @package com.biz.crm.moblie.visitoffline
 * @date 2021/6/23 19:20
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_COMPETITOR + SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "SfaStepCompetitorComponentExpandImpl")
@Slf4j
public class SfaStepCompetitorComponent implements SfaVisitStepOffLineStrategy {

    private static String STEP_CODE;

    /**
     * 对应app的控件名称
     */
    private final static String photo_key_name = "图片上传";

    @Resource
    private CompetitorVisitStepExecutor competitorVisitStepExecutor;
    @Resource
    private SfaVisitStepColletProductMapper sfaVisitStepColletProductMapper;
    @Resource
    private ISfaVisitStepColletService sfaVisitStepColletService;


    @Override
    public <T> T buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepComponentVo vo = new SfaVisitStepComponentVo();

        SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil(getStepCode(), reqVo.getVisitPlanInfoId());

        ExecutorLoadReq loadReq = CrmBeanUtil.copy(reqVo, ExecutorLoadReq.class);
        //查询表单执行数据
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp) competitorVisitStepExecutor.load(loadReq);
        //设置表单数据
        vo.setSfaVisitStepFrom(dataResp.getSfaVisitStepFrom());
        SfaVisitStepColletProductReqVo productReqVo = new SfaVisitStepColletProductReqVo() {{
            this.setPageSize(-1);
            this.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            this.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }};
        //查询竟品采集的商品数据
        List<SfaVisitStepColletProductRespVo> productList = sfaVisitStepColletProductMapper.findListProduct(null, productReqVo);
        vo.setProductList(productList);
        SfaVisitOffLinePhotoVo photoKey = SfaVisitOffLinePhotoVo.builder()
                .key(photo_key_name)
                .photoKey(util.getPhotoOffLineKey(AttachmentBizTypeEnum.VISIT_STEP_COLLET.getVal(), AttachmentBizTypeEnum.VISIT_STEP_COLLET.getDesc()))
                .build();
        List<SfaVisitOffLinePhotoVo> offLinePhotoVoList = Lists.newArrayList(photoKey);
        vo.setOffLinePhotoKey(offLinePhotoVoList);
        return (T) vo;
    }

    /**
     * 离线图片保存
     * @param list
     * @param util
     */
    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepColletEntity entity = sfaVisitStepColletService.lambdaQuery()
                .eq(SfaVisitStepColletEntity::getVisitPlanInfoId,util.getVisitPlanInfoId())
                .eq(SfaVisitStepColletEntity::getStepCode,util.getStepCode())
                .select(SfaVisitStepColletEntity::getId)
                .one();
        if (null != entity){
            List<SfaAttachmentEntity> fileEntity = list.stream().map(data->{
                SfaAttachmentEntity file = CrmBeanUtil.copy(data,SfaAttachmentEntity.class);
                file.setBizId(entity.getId());
                file.setAttachmentBizType(util.getType());
                file.setAttachmentBizTypeName(util.getTypeName());
                return file;
            }).collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntity);
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }


    /**
     * 竟品采集离线数据保存
     *
     * @param req
     */
    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq<CompetitorStepExecuteData> visitStepExecuteReq = CrmBeanUtil.copy(req, VisitStepExecuteReq.class);
            CompetitorStepExecuteData executeData = JSONObject.parseObject(JSONObject.toJSONString(req.getStepExecuteData()),CompetitorStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            competitorVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        }catch (BusinessException e){
            log.warn("竟品采集错误信息:{}",e.getMsg());
            result.setSuccess(false);
            result.setMessage("拜访步骤:竟品采集错误信息["+e.getMsg()+"]");
        }
        return result;
    }
}
