package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.impl.ActivityCostVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.component.impl.ActivityDisplayVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepCostVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe 费用活动
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepcomponent
 * @date 2021/6/23 19:47
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_COST + SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "SfaStepCostComponentExpandImpl")
@Slf4j
public class SfaStepCostComponent implements SfaVisitStepOffLineStrategy {

    private static String STEP_CODE;

    @Resource
    private ISfaVisitStepFromService sfaVisitStepFromService;

    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;

    @Resource
    private ActivityCostVisitStepExecutor activityCostVisitStepExecutor;

    @Resource
    private ActivityDisplayVisitStepExecutor activityDisplayVisitStepExecutor;

    @Override
    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepCostVo vo = new SfaVisitStepCostVo();
        //查询列表
        LoadVisitActivityListReq req = CrmBeanUtil.copy(reqVo, LoadVisitActivityListReq.class);
        req.setActivityType(SfaActivityEnum.activityType.COST_ACTIVITY.getVal());
        List<SfaActivityExecutionEntityResp> pageResult = sfaVisitStepActivityExecutionService.loadVisitActivityList(req);
        List<SfaVisitStepCostVo.SfaCostActivityExecutionVo> list = CrmBeanUtil.copyList(pageResult, SfaVisitStepCostVo.SfaCostActivityExecutionVo.class);
        vo.setList(list);
        return vo;
    }

    /**
     * 费用活动离线数据保存
     *
     * @param req
     */
    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq = CrmBeanUtil.copy(req, VisitStepExecuteReq.class);
            ActivityStepExecuteData executeData = JSONObject.parseObject(JSONObject.toJSONString(req.getStepExecuteData()),ActivityStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            ActivityStepExecuteData dataReq = visitStepExecuteReq.getStepExecuteData();
            if (org.apache.commons.lang3.StringUtils.isBlank(dataReq.getId())) {
                throw new BusinessException("活动执行明细ID为空");
            }
            SfaVisitStepActivityExecutionEntity executionEntity = this.sfaVisitStepActivityExecutionService.getById(visitStepExecuteReq.getStepExecuteData().getId());
            if (null == executionEntity) {
                throw new BusinessException("未查询到活动执行明细");
            }
            if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(executionEntity.getActivityType())) {
                activityDisplayVisitStepExecutor.executeOffLine(visitStepExecuteReq);
            } else {
                activityCostVisitStepExecutor.executeOffLine(visitStepExecuteReq);
            }
        }catch (BusinessException e){
            log.error("费用活动错误信息:{}",e.getMsg());
            result.setSuccess(false);
            result.setMessage("费用活动:错误信息["+e.getMsg()+"]");
        }
        return result;
    }

    /**
     * 离线图片保存
     *
     * @param list
     * @param util
     */
    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepActivityExecutionEntity entity = sfaVisitStepActivityExecutionService.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionEntity::getVisitPlanInfoId, util.getVisitPlanInfoId())
                .eq(SfaVisitStepActivityExecutionEntity::getStepCode, util.getStepCode())
                .select(SfaVisitStepActivityExecutionEntity::getId).one();
        if (null != entity) {
            List<SfaAttachmentEntity> fileEntityList = list.stream().map(data->{
                SfaAttachmentEntity file = CrmBeanUtil.copy(data,SfaAttachmentEntity.class);
                file.setBizId(entity.getId());
                file.setAttachmentBizType(util.getType());
                file.setAttachmentBizTypeName(util.getTypeName());
                return file;
            }) .collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntityList);
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }
}
