package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.biz.crm.actscheme.service.ISfaActSchemePosApplyService;
import com.biz.crm.asexecution.service.ISfaAsExecutionService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecutionDetailReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsTreatyReqVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionDetailRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepProgrammeVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lf
 * @describe 方案活动
 * @project crm
 * @package com.biz.crm.moblie.visitoffline
 * @date 2021/6/23 18:30
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_DEF_PROGRAMME+SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "sfaStepCodeDefProgrammeExpandImpl")
@Slf4j
public class SfaStepDefProgrammeComponent implements SfaVisitStepOffLineStrategy {

    private static String STEP_CODE;

    @Resource
    private ISfaActSchemePosApplyService sfaActSchemePosApplyService;
    @Resource
    private ISfaAsExecutionService sfaAsExecutionService;

    @Override
    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepProgrammeVo vo = new SfaVisitStepProgrammeVo();

        SfaVisitStepActivityExecutionReqVo executionReqVo = CrmBeanUtil.copy(reqVo,SfaVisitStepActivityExecutionReqVo.class);
        executionReqVo.setPageSize(-1);
        executionReqVo.setActivityType(SfaActivityEnum.activityType.SCHEME_ACTIVITY.getVal());
        PageResult<SfaActivityExecutionRespVo> pageResult = sfaActSchemePosApplyService.findActSchemeList(executionReqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(pageResult.getData())){
            List<SfaVisitStepProgrammeVo.SfaProgrammeActivityExecutionVo> list = CrmBeanUtil.copyList(pageResult.getData(), SfaVisitStepProgrammeVo.SfaProgrammeActivityExecutionVo.class);
            list.forEach(data->{
                SfaAsExecutionDetailReqVo detailReqVo = new SfaAsExecutionDetailReqVo(){{
                    this.setActivityCode(data.getActivityCode());
                    this.setTerminalCode(reqVo.getClientCode());
                }};
                SfaAsExecutionDetailRespVo respVo = sfaAsExecutionService.queryExecutionDetailByActivityCodeAndTerminalCode(detailReqVo);
                data.setDetailRespVo(respVo);
            });
            vo.setList(list);
        }
        return vo;
    }

    /**
     * 保存拜访离线数据-方案活动
     * @param req
     */
    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            if (null != req.getTreatyReqVo()){
                sfaAsExecutionService.saveSfaAsTreaty(req.getTreatyReqVo());
            }
            if (null != req.getExecutionReqVo()){
                sfaAsExecutionService.saveSfaAsExecution(req.getExecutionReqVo());
            }
        }catch (BusinessException e){
            log.error("方案活动错误信息:{}",e.getMsg());
            result.setSuccess(false);
            result.setMessage("方案活动:错误信息["+e.getMsg()+"]");
        }
        return result;
    }


    /**
     * 离线图片保存
     * @param list
     * @param util
     */
    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {

    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }
}
