package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.moblie.controller.visit.component.impl.HelpScoreVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.HelpScoreStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepHelpScoreVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepcomponent
 * @date 2021/6/23 20:16
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_HELP_SCORE + SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "SfaStepHelpScoreComponentExpandImpl")
@Slf4j
public class SfaStepHelpScoreComponent implements SfaVisitStepOffLineStrategy {

    @Resource
    private HelpScoreVisitStepExecutor helpScoreVisitStepExecutor;

    private static String STEP_CODE;

    @Override
    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepHelpScoreVo vo = new SfaVisitStepHelpScoreVo();
        ExecutorLoadReq loadReq = CrmBeanUtil.copy(reqVo, ExecutorLoadReq.class);
        HelpScoreStepExecuteDataResp dataResp = (HelpScoreStepExecuteDataResp) helpScoreVisitStepExecutor.load(loadReq);
        vo.setSfaVisitStepFrom(dataResp.getSfaVisitStepFrom());
        vo.setHelpScoreDetailList(dataResp.getHelpScoreDetailList());
        return vo;
    }

    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq<HelpScoreStepExecuteData> visitStepExecuteReq = CrmBeanUtil.copy(req, VisitStepExecuteReq.class);
            HelpScoreStepExecuteData executeData = JSONObject.parseObject(JSONObject.toJSONString(req.getStepExecuteData()),HelpScoreStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            helpScoreVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        } catch (BusinessException e) {
            log.error("协防评价错误信息:{}", e.getMsg());
            result.setSuccess(false);
            result.setMessage("协防评价:错误信息["+e.getMsg()+"]");
        }
        return result;
    }

    /**
     * 离线图片保存
     *
     * @param list
     * @param util
     */
    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {

    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }
}
