package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.moblie.controller.visit.component.impl.OrderVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepOrderVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe 代客下单
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepcomponent
 * @date 2021/6/23 19:25
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_ORDER+SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "SfaStepOrderComponentExpandImpl")
@Slf4j
public class SfaStepOrderComponent implements SfaVisitStepOffLineStrategy {

    private static String STEP_CODE;

    @Resource
    private OrderVisitStepExecutor orderVisitStepExecutor;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;

    /**
     * build 拜访步骤离线数据vo
     *
     * @param reqVo
     * @return
     */
    @Override
    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepOrderVo vo = new SfaVisitStepOrderVo();
        //查询表单数据
        ExecutorLoadReq req = CrmBeanUtil.copy(reqVo, ExecutorLoadReq.class);
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp) orderVisitStepExecutor.load(req);
        vo.setSfaVisitStepFrom(dataResp.getSfaVisitStepFrom());
        //查询供货经销商
        List<MdmTerminalSupplyVo> mdmTerminalSupplyVos = sfaVisitStepOrderService.findTerminalSupplyList(reqVo.getClientCode());
        vo.setSupplyVoList(mdmTerminalSupplyVos);
        return vo;
    }

    /**
     * 保存拜访步骤离线数据vo
     *
     * @param req
     */
    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq<OrderStepExecuteData> visitStepExecuteReq = CrmBeanUtil.copy(req, VisitStepExecuteReq.class);
            OrderStepExecuteData executeData = JSONObject.parseObject(JSONObject.toJSONString(req.getStepExecuteData()),OrderStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            orderVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        }catch (BusinessException e){
            log.error("代客下单错误信息:{}",e.getMsg());
            result.setSuccess(false);
            result.setMessage("代客下单:错误信息["+e.getMsg()+"]");
        }
        return result;
    }


    /**
     * 离线图片保存
     * @param list
     * @param util
     */
    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepOrderEntity entity = sfaVisitStepOrderService.lambdaQuery()
                .eq(SfaVisitStepOrderEntity::getVisitPlanInfoId,util.getVisitPlanInfoId())
                .eq(SfaVisitStepOrderEntity::getStepCode,util.getStepCode())
                .select(SfaVisitStepOrderEntity::getId)
                .one();
        if (null != entity){
            List<SfaAttachmentEntity> fileEntity = list.stream().map(data->{
                SfaAttachmentEntity file = CrmBeanUtil.copy(data,SfaAttachmentEntity.class);
                file.setBizId(entity.getId());
                file.setAttachmentBizType(util.getType());
                file.setAttachmentBizTypeName(util.getTypeName());
                return file;
            }).collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntity);
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }
}
