package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.moblie.controller.visit.component.impl.StoreCheckVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepStoreCheckVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLinePhotoVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe 店面检查
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepcomponent
 * @date 2021/6/23 20:13
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_STORE_CHECK + SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "SfaStepStoreCheckComponentExpandImpl")
@Slf4j
public class SfaStepStoreCheckComponent implements SfaVisitStepOffLineStrategy {

    private static String STEP_CODE;

    private final static String REGULAR_SHELF_DISPLAY = "常规货架陈列";

    private final static String MATERIAL_DISPLAY = "物料陈列";

    private final static String PRICE_DISPLAY = "价格标签";

    @Resource
    private StoreCheckVisitStepExecutor storeCheckVisitStepExecutor;
    @Resource
    private ISfaVisitStepStoreCheckService sfaVisitStepStoreCheckService;

    @Override
    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepStoreCheckVo vo = new SfaVisitStepStoreCheckVo();

        SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil(getStepCode(), reqVo.getVisitPlanInfoId());

        ExecutorLoadReq req = CrmBeanUtil.copy(reqVo, ExecutorLoadReq.class);
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp) storeCheckVisitStepExecutor.load(req);
        vo.setSfaVisitStepFrom(dataResp.getSfaVisitStepFrom());
        //离线图片key
        SfaVisitOffLinePhotoVo regularShelfDisplay = SfaVisitOffLinePhotoVo.builder()
                .key(REGULAR_SHELF_DISPLAY)
                .photoKey(util.getPhotoOffLineKey(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getDesc()))
                .build();
        SfaVisitOffLinePhotoVo materialDisplay = SfaVisitOffLinePhotoVo.builder()
                .key(MATERIAL_DISPLAY)
                .photoKey(util.getPhotoOffLineKey(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getDesc()))
                .build();
        SfaVisitOffLinePhotoVo checkPrice = SfaVisitOffLinePhotoVo.builder()
                .key(PRICE_DISPLAY)
                .photoKey(util.getPhotoOffLineKey(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getDesc()))
                .build();
        List<SfaVisitOffLinePhotoVo> offLinePhotoVoList = Lists.newArrayList(regularShelfDisplay,materialDisplay,checkPrice);
        vo.setOffLinePhotoKey(offLinePhotoVoList);
        return vo;
    }

    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq<StoreCheckStepExecuteData> visitStepExecuteReq = CrmBeanUtil.copy(req, VisitStepExecuteReq.class);
            StoreCheckStepExecuteData executeData = JSONObject.parseObject(JSONObject.toJSONString(req.getStepExecuteData()),StoreCheckStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            storeCheckVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        }catch (BusinessException e){
            log.error("店面检查错误信息:{}",e.getMsg());
            result.setSuccess(false);
            result.setMessage("店面检查:错误信息["+e.getMsg()+"]");
        }
        return result;
    }


    /**
     * 离线图片数据保存
     * @param list
     * @param util
     */
    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepStoreCheckEntity entity = sfaVisitStepStoreCheckService.lambdaQuery()
                .eq(SfaVisitStepStoreCheckEntity::getVisitPlanInfoId,util.getVisitPlanInfoId())
                .eq(SfaVisitStepStoreCheckEntity::getStepCode,util.getStepCode())
                .select(SfaVisitStepStoreCheckEntity::getId)
                .one();
        if (null != entity){
            List<SfaAttachmentEntity> fileEntity = list.stream().map(data->{
                SfaAttachmentEntity file = CrmBeanUtil.copy(data,SfaAttachmentEntity.class);
                file.setBizId(entity.getId());
                file.setAttachmentBizType(util.getType());
                file.setAttachmentBizTypeName(util.getTypeName());
                return file;
            }).collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntity);
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }
}
