package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepTpmActVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLinePhotoVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectFormVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.model.SfaVisitStepTpmActCollectEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.tpmact.service.ISfaVisitStepTpmActCollectService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepcomponent
 * @date 2021/6/23 20:05
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_TPM + SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "SfaStepTpmComponentExpandImpl")
@Slf4j
public class SfaStepTpmComponent implements SfaVisitStepOffLineStrategy {

    private static String STEP_CODE;

    @Resource
    private ISfaAsTreatyService sfaAsTreatyService;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Resource
    private ISfaVisitStepTpmActCollectService sfaVisitStepTpmActCollectService;
    @Resource
    private ISfaTpmActDetailService sfaTpmActDetailService;
    @Resource
    private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private RedisService redisService;

    @Override
    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        SfaVisitStepTpmActVo vo = new SfaVisitStepTpmActVo();

        SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil(getStepCode(), reqVo.getVisitPlanInfoId());

        SfaTpmActReqVo tpmActReqVo = new SfaTpmActReqVo();
        tpmActReqVo.setTerminalCode(reqVo.getClientCode());
        tpmActReqVo.setSfaTpmActStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
        tpmActReqVo.setPageSize(-1);
        PageResult<SfaTpmActRespVo> pageResult = sfaTpmActDetailService.getTpmActList(tpmActReqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(pageResult.getData())) {
            List<SfaVisitStepTpmActVo.SfaTpmActVo> list = CrmBeanUtil.copyList(pageResult.getData(), SfaVisitStepTpmActVo.SfaTpmActVo.class);
            list.forEach(data -> {
                SfaTpmActDetailRespVo respVo = sfaTpmActDetailService.getTpmActDetailByActDetailCode(data.getActDetailCode(), reqVo.getClientCode(), reqVo.getRedisHashKey(), reqVo.getVisitPlanInfoId());
                SfaVisitStepTpmActVo.SfaTpmActDetailVo detailVo = CrmBeanUtil.copy(respVo, SfaVisitStepTpmActVo.SfaTpmActDetailVo.class);
                if (respVo.getExt25() != null && respVo.getExt53() != null) {
                    String desc = "买" + respVo.getExt25() + "赠" + respVo.getExt53();
                    detailVo.setRemarks(desc);
                    if (StringUtils.isNotEmpty(respVo.getRemarks())) {
                        detailVo.setRemarks("," + respVo.getRemarks());
                    }
                    detailVo.setBuy(respVo.getExt25().intValue());
                    detailVo.setPresent(respVo.getExt53().intValue());
                }
                //判断是否有活动数据采集
                if (YesNoEnum.yesNoEnum.Y.getValue().equals(detailVo.getIsCollectActData())) {
                    List<SfaTpmActCollectFormVo> formVoList = CrmBeanUtil.copyList(sfaTpmActDetailService.findActCollectDataForm(detailVo.getFineCode(), detailVo.getActDetailCode()), SfaTpmActCollectFormVo.class);

                    if (CollectionUtil.listNotEmptyNotSizeZero(formVoList)) {
                        formVoList.forEach(form -> {
                            SfaTpmActCollectFormVo.SfaVisitOffLinePhotoVo photoKey = new SfaTpmActCollectFormVo.SfaVisitOffLinePhotoVo();
                            photoKey.setKey(form.getExampleName());
                            //tpm活动特殊处理
                            photoKey.setPhotoKey(util.getPhotoOffLineKey(form.getExampleCode(), form.getExampleName(), data.getActDetailCode()));
                            List<SfaTpmActCollectFormVo.SfaVisitOffLinePhotoVo> offLinePhotoVoList = Lists.newArrayList(photoKey);
                            form.setOffLinePhotoKey(offLinePhotoVoList);
                        });
                        detailVo.setFormVoList(formVoList);
                    }
                }
                data.setDetailRespVo(detailVo);
                List<SfaTpmActDetailProductEntity> productEntityList = this.sfaTpmActDetailProductService.lambdaQuery()
                        .eq(SfaTpmActDetailProductEntity::getActDetailCode, data.getActDetailCode()).list();
                if (CollectionUtil.listNotEmptyNotSizeZero(productEntityList)) {
                    List<SfaTpmActDetailProductRespVo> productRespVos = CrmBeanUtil.copyList(productEntityList, SfaTpmActDetailProductRespVo.class);
                    Map<String, List<SfaTpmActDetailProductRespVo>> productMap = productRespVos.stream().collect(Collectors.groupingBy(SfaTpmActDetailProductRespVo::getIsGiftProduct));
                    productMap.entrySet().forEach(pd -> {
                        if (null != pd.getKey() && pd.getKey().contains(YesNoEnum.yesNoEnum.Y.getValue())) {
                            data.setZpProductList(pd.getValue());
                        } else {
                            data.setBpProductList(pd.getValue());
                        }
                    });
                }
            });
            vo.setList(list);
            Result<List<MdmTerminalSupplyVo>> result = mdmTerminalFeign.findTerminalSupply(new MdmTerminalVo() {{
                this.setTerminalCodeList(Lists.newArrayList(reqVo.getClientCode()));
            }});
            List<MdmTerminalSupplyVo> terminalSupplyVos = null;
            if (result.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero(result.getResult())) {
                terminalSupplyVos = result.getResult();
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(terminalSupplyVos)) {
                List<SfaVisitStepTpmActVo.DealerVo> dealerVoList = CrmBeanUtil.copyList(terminalSupplyVos, SfaVisitStepTpmActVo.DealerVo.class);
                dealerVoList = dealerVoList.stream().filter(data -> StringUtils.isNotEmpty(data.getCustomerCode())).collect(Collectors.toList());
                vo.setDealerVoList(dealerVoList);
            } else {
                throw new BusinessException("TPM活动:获取当前终端的上级经销商失败");
            }
        }
        return vo;
    }

    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitBaseVo visitBaseVo = CrmBeanUtil.copy(req, VisitBaseVo.class);
            if (CollectionUtil.listNotEmptyNotSizeZero(req.getSfaTpmActVos())) {
                List<VisitStepOffLineExecuteReq.SfaOffLineTpmActVo> sfaOffLineTpmActVos = req.getSfaTpmActVos();
                sfaOffLineTpmActVos.forEach(data -> {
                    if (null != data.getGoodsTreatyVo()) {
                        data.getGoodsTreatyVo().setLineStatus(SfaVisitEnum.VISIT_OFF_LINE.offline.getVal());
                        visitBaseVo.setStepExecuteData(data.getGoodsTreatyVo());
                        sfaAsTreatyService.saveVisitStepGoodsTreaty(visitBaseVo);
                    }
                    if (null != data.getCashTreatyVo()) {
                        data.getCashTreatyVo().setLineStatus(SfaVisitEnum.VISIT_OFF_LINE.offline.getVal());
                        visitBaseVo.setStepExecuteData(data.getCashTreatyVo());
                        sfaAsTreatyService.saveVisitStepCashTreaty(visitBaseVo);
                    }
                    if (null != data.getDistributionOrderVo() && CollectionUtil.listNotEmptyNotSizeZero(data.getDistributionOrderVo().getBpProductList())) {
                        data.getDistributionOrderVo().setLineStatus(SfaVisitEnum.VISIT_OFF_LINE.offline.getVal());
                        visitBaseVo.setStepExecuteData(data.getDistributionOrderVo());
                        sfaVisitStepOrderService.saveVisitStepDistributionOrder(visitBaseVo);
                    }
                    if (null != data.getTpmActCollectVo() && CollectionUtil.listNotEmptyNotSizeZero(data.getTpmActCollectVo().getCollectFormList())) {
                        data.getTpmActCollectVo().setLineStatus(SfaVisitEnum.VISIT_OFF_LINE.offline.getVal());
                        visitBaseVo.setStepExecuteData(data.getTpmActCollectVo());
                        sfaVisitStepTpmActCollectService.saveVisitStepActCollect(visitBaseVo);
                    }
                });
            }
        } catch (BusinessException e) {
            log.error("TPM活动错误信息:" + e.getMsg());
            result.setMessage("TPM活动:错误信息[" + e.getMsg() + "]");
            result.setSuccess(false);
        }
        return result;
    }

    /**
     * 图片保存
     *
     * @param list
     * @param util
     */
    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepTpmActCollectEntity entity = sfaVisitStepTpmActCollectService.lambdaQuery()
                .eq(SfaVisitStepTpmActCollectEntity::getVisitPlanInfoId, util.getVisitPlanInfoId())
                .eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, util.getActCode())
                .eq(SfaVisitStepTpmActCollectEntity::getStepCode, util.getStepCode())
                .select(SfaVisitStepTpmActCollectEntity::getId)
                .one();
        if (null != entity) {
            List<SfaAttachmentEntity> fileEntity = list.stream().map(data -> {
                SfaAttachmentEntity file = CrmBeanUtil.copy(data, SfaAttachmentEntity.class);
                file.setBizId(entity.getId());
                file.setAttachmentBizTypeName(util.getTypeName());
                file.setAttachmentBizType(util.getType());
                return file;
            }).collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntity);
            //删除最开始可能存在的缓存数据
            redisService.hdel(SfaTpmActCollectVo.getRedisHashKey(entity.getId()), entity.getId());
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }

}
