package com.biz.crm.moblie.visitoffline.stepdatavo;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityBgSetmealRespVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityProductRespVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityRangeRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionDetailRespVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionTypeRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepdatavo
 * @date 2021/6/23 18:48
 */
@Data
@ApiModel("离线数据vo-方案活动")
public class SfaVisitStepProgrammeVo {

    @ApiModelProperty("表单数据")
    private SfaVisitStepFromRespVo sfaVisitStepFrom;

    @ApiModelProperty("方案活动数据")
    private List<SfaProgrammeActivityExecutionVo> list;

    @Data
    @ApiModel("方案活动data")
    public static class SfaProgrammeActivityExecutionVo extends CrmExtTenVo {
        @ApiModelProperty("活动名称")
        @SaturnColumn(description = "活动名称")
        private String activityName;

        @ApiModelProperty("活动类型(cost-费用活动,display-陈列活动,bg-方案活动)")
        @SaturnColumn(description = "活动类型(cost-费用活动,display-陈列活动,bg-方案活动)")
        private String activityType;

        @ApiModelProperty("活动类型(cost-费用活动,display-陈列活动,bg-方案活动)")
        @CrmDict(typeCode = "sfa_activity_type",dictCodeField = "activityType")
        private String activityTypeDesc;

        @ApiModelProperty("活动编码")
        private String activityCode;

        @ApiModelProperty("活动状态(0-未开始,1-已开始,2-已结束)")
        private String activityStatus;

        @ApiModelProperty("活动状态(0-未开始,1-已开始,2-已结束)")
        @CrmDict(typeCode = "sfa_activity_status",dictCodeField = "activityStatus")
        private String activityStatusDesc;

        @ApiModelProperty("网点名称")
        private String clientName;

        @ApiModelProperty("活动执行开始时间")
        @SaturnColumn(description = "活动执行开始时间")
        private String activityStartTime;

        @ApiModelProperty("活动执行结束时间")
        @SaturnColumn(description = "活动执行结束时间")
        private String activityEndTime;

        @ApiModelProperty("上次执行时间")
        private String lastActivityTime;

        @ApiModelProperty("销售额")
        @SaturnColumn(description = "销售额")
        private String salesVolume;

        @ApiModelProperty("申请金额")
        @SaturnColumn(description = "申请金额")
        private String applyAmount;

        @ApiModelProperty("活动要求(0-活动照,1-门头照,2-陈列照)")
        @SaturnColumn(description = "活动要求(0-活动照,1-门头照,2-陈列照)")
        private String activityRequire;

        @ApiModelProperty("活动要求(0-活动照,1-门头照,2-陈列照)")
        @CrmDict(typeCode = "sfa_activity_require",dictCodeField = "activityRequire")
        private String activityRequireDesc;

        @ApiModelProperty("活动描述")
        @SaturnColumn(description = "活动描述")
        private String activityDesc;

        @ApiModelProperty("活动执行频率(天)")
        @SaturnColumn(description = "活动执行频率(天)")
        private String activityFrequency;

        @ApiModelProperty("人员账号")
        @SaturnColumn(description = "人员账号")
        private String userName;

        @ApiModelProperty("人员姓名")
        @SaturnColumn(description = "人员姓名")
        private String realName;

        @ApiModelProperty("职位名称")
        @SaturnColumn(description = "职位名称")
        private String posName;

        @ApiModelProperty("职位编码")
        @SaturnColumn(description = "职位编码")
        private String posCode;

        @ApiModelProperty("组织名称")
        @SaturnColumn(description = "组织名称")
        private String orgName;

        @ApiModelProperty("组织编码")
        @SaturnColumn(description = "组织编码")
        private String orgCode;

        @ApiModelProperty("活动执行时间")
        private String activityTime;

        @ApiModelProperty("活动范围列表")
        private List<SfaActivityRangeRespVo> activityRangeList;

        @ApiModelProperty("活动产品列表")
        private List<SfaActivityProductRespVo> activityProductList;

        @ApiModelProperty("活动示例图片列表")
        private List<SfaVisitPictureRespVo> visitPictureList;

        @ApiModelProperty("活动执行类型拍照图片列表")
        private List<SfaVisitStepActivityExecutionTypeRespVo> stepActivityExecutionTypeList;

        @ApiModelProperty("组织分类范围列表")
        private List<SfaActivityRangeRespVo> orgRangeList;

        @ApiModelProperty("渠道分类范围列表")
        private List<SfaActivityRangeRespVo> channelRangeList;

        @ApiModelProperty("客户分类范围列表")
        private List<SfaActivityRangeRespVo> customerRangeList;

        @ApiModelProperty("方案活动套餐列表")
        private List<SfaActivityBgSetmealRespVo> activityBgSetmealList;

        @ApiModelProperty("方案活动详细信息")
        private SfaAsExecutionDetailRespVo detailRespVo;
    }

}
