package com.biz.crm.moblie.visitoffline.stepdatavo;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectFormVo;
import com.biz.crm.nebular.sfa.tpmact.resp.ExecuteDataRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.util.DictUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepdatavo
 * @date 2021/6/24 18:45
 */
@Data
@ApiModel("离线数据vo-tpm活动")
public class SfaVisitStepTpmActVo implements Serializable {

    @ApiModelProperty("tpm活动数据列表")
    private List<SfaTpmActVo> list;

    @ApiModelProperty("陈列位置-数据字典")
    private Map<String, String> displayPlaceMap;

    @ApiModelProperty("经销商数据")
    private List<DealerVo> dealerVoList;

    public SfaVisitStepTpmActVo() {
        this.displayPlaceMap = DictUtil.dictMap(DictConstant.DISPLAY_PLACE);
    }


    @Data
    @ApiModel("tpm活动数据列表")
    public static class SfaTpmActVo extends CrmBaseVo {
        @ApiModelProperty("活动编码")
        private String actDetailCode;

        @ApiModelProperty("活动名称")
        private String actName;

        @ApiModelProperty("活动描述")
        private String actDesc;

        @ApiModelProperty("开始时间-年月日")
        private String beginDate;

        @ApiModelProperty("结束时间-年月日")
        private String endDate;

        @ApiModelProperty("活动总金额")
        private String actAmount;

        @ApiModelProperty("已使用金额")
        private BigDecimal usedAmount;

        @ApiModelProperty("本店已使用金额")
        private BigDecimal currentUsedAmount;

        @ApiModelProperty("活动状态")
        private String actStatusName;

        @ApiModelProperty("tpm活动详细数据")
        private SfaTpmActDetailVo detailRespVo;

        @ApiModelProperty("tpm活动-本品商品")
        private List<SfaTpmActDetailProductRespVo> bpProductList;

        @ApiModelProperty("tpm活动-赠品商品")
        private List<SfaTpmActDetailProductRespVo> zpProductList;

    }


    @Data
    @ApiModel("sfa tpm活动详细数据")
    public static class SfaTpmActDetailVo extends CrmExtTenVo {
        @ApiModelProperty("活动名称")
        private String actName;

        @ApiModelProperty("活动描述")
        private String actDesc;

        @ApiModelProperty("活动明细编码")
        private String actDetailCode;

        @ApiModelProperty("活动细类编码")
        private String fineCode;

        @ApiModelProperty("支付方式名称")
        private String payTypeName;

        @ApiModelProperty("活动开始时间")
        private String beginDate;

        @ApiModelProperty("活动结束时间")
        private String endDate;

        @ApiModelProperty("是否采集活动数据(Y/N)")
        private String isCollectActData;

        @ApiModelProperty("是否采集分销订单(Y/N)")
        private String isCollectDistributionOrder;

        @ApiModelProperty("是否签署陈列协议(Y/N)")
        private String isSignDisplayAgreement;

        @ApiModelProperty("陈列协议id")
        private String displayAgreementId;

        @ApiModelProperty("是否控制活动费用(Y/N)")
        private String isControlActFee;

        @ApiModelProperty("陈列协议-现金协议,货品协议")
        private String paymentMethod;

        @CrmDict(typeCode = "payment_method", dictCodeField = "paymentMethod")
        @ApiModelProperty("陈列协议-现金协议,货品协议")
        private String paymentMethodName;

        @ApiModelProperty("活动折让价格")
        private BigDecimal eventPrice;

        @ApiModelProperty("公司承担金额")
        private BigDecimal Commitment;

        @ApiModelProperty("分销订单类型")
        private String distributionOrderType;

        @ApiModelProperty("分销订单id-拜访页面使用")
        private String distributionOrderId;

        @ApiModelProperty("采集活动数据id-拜访页面使用")
        private String actCollectDataId;

        @ApiModelProperty("分销订单类型")
        private String distributionOrderTypeName;

        @ApiModelProperty("活动数据采集动态表单配置")
        private List<SfaTpmActCollectFormVo> formVoList;

        @ApiModelProperty("买几")
        private Integer buy;

        @ApiModelProperty("赠几")
        private Integer present;

    }

    @Data
    @ApiModel("经销商vo")
    public static class DealerVo {

        private String customerCode;

        private String customerName;
    }

    @Data
    @ApiModel("产品层级vo")
    public static class ProductLevelVo {

        @ApiModelProperty("产品层级名称")
        private String productLevelName;

        @ApiModelProperty("产品层级编码")
        private String productLevelCode;

        @ApiModelProperty("产品层级类型")
        private String productLevelType;

        @ApiModelProperty("层级")
        private Integer levelNum;

        @ApiModelProperty("降维编码")
        private String roleCode;
    }
}
