package com.biz.crm.mqconsumer;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.activity.req.ActivityExecutionResolveData;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;


/**
 * SFA活动执行明细解析
 *  @author: luoqi
 *  @Date: 2021-4-13 16:57
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.SFA_ACTIVITY_EXECUTION_RESOLVE,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.SFA_ACTIVITY_EXECUTION_RESOLVE + "${rocketmq.environment-variable}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY)
public class SfaActivityExecutionResolveConsumer extends AbstractRocketMQConsumer {

    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private SfaVisitStepActivityExecutionServiceImpl sfaVisitStepActivityExecutionServiceImpl;

    /**
     *向子类提供扩展
     * @return
     */
    protected VisitDataDurabilityService getVisitDataDurabilityService(){
        return sfaVisitStepActivityExecutionServiceImpl;
    }

    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    //获取消息
    @Override
    protected Object handleMessage(RocketMQMessageBody message){
//        if (true) {
//            return "清除垃圾消息";
//        }
//        String msgBody = message.getMsgBody();
//        ActivityExecutionResolveData resolveData = JsonPropertyUtil.toObject(msgBody, ActivityExecutionResolveData.class);
//        if(this.hasOldData(resolveData)){
//            return "已经存在执行过的老数据,跳过活动明细数据写入";
//        }
//        SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(resolveData);
//        this.getVisitDataDurabilityService().dataDurability(Lists.newArrayList(redisData), null);
//        return "SFA活动执行明细解析完成";

        log.info("SFA活动执行明细解析");

        List<SfaVisitStepActivityExecutionRedisData> executionRedisDataList = new ArrayList<>();

        String msgBody = message.getMsgBody();
        List<ActivityExecutionResolveData> resolveDataList = JsonPropertyUtil.toArray(msgBody, ActivityExecutionResolveData.class);
        resolveDataList.forEach(resolveData -> {
            //已经存在执行过的老数据,跳过活动明细数据写入
            if (this.hasOldData(resolveData)) {
                return;
            }
            SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(resolveData);
            //TODO 2.0版本需要设置数据状态
            redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
            executionRedisDataList.add(redisData);
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(executionRedisDataList)) {
            this.getVisitDataDurabilityService().dataDurability(executionRedisDataList, null);
        }
        return "SFA活动执行明细解析完成";
    }

    protected boolean hasOldData(ActivityExecutionResolveData resolveData){
        String resolveDate = resolveData.getResolveDate();
        SfaActivityExecutionEntity executionEntity = resolveData.getActivityExecutionEntity();
        SfaClientData clientData = resolveData.getClientData();
        LambdaQueryChainWrapper<SfaVisitStepActivityExecutionEntity> lambdaQueryChainWrapper = this.sfaVisitStepActivityExecutionService.lambdaQuery()
                .eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, executionEntity.getId())
                .eq(SfaVisitStepActivityExecutionEntity::getClientCode, clientData.getClientCode());
        SfaVisitStepActivityExecutionRedisData data;
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(executionEntity.getActivityType())) {
            data = this.sfaVisitStepActivityCostExecutionEsDataRepositories.findByActivityExecutionIdAndClientCode
                    (executionEntity.getId(), clientData.getClientCode());
        } else {
            data = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.findByActivityExecutionIdAndClientCodeAndActivityDate
                    (executionEntity.getId(), clientData.getClientCode(), resolveDate);
            lambdaQueryChainWrapper.eq(SfaVisitStepActivityExecutionEntity::getActivityDate, resolveDate);
        }
        if (null != data) {
            return true;
        }
        SfaVisitStepActivityExecutionEntity stepActivityExecutionEntity = lambdaQueryChainWrapper.one();
        if (null != stepActivityExecutionEntity) {
            return true;
        }
        return false;
    }



    protected SfaVisitStepActivityExecutionRedisData buildRedisData(ActivityExecutionResolveData resolveData){
        SfaClientData clientData = resolveData.getClientData();
        LocalDate resolveDate = LocalDate.parse(resolveData.getResolveDate(), CrmDateUtils.yyyyMMdd);
        SfaActivityExecutionEntity executionEntity = resolveData.getActivityExecutionEntity();
        SfaVisitStepActivityExecutionRedisData redisData = new SfaVisitStepActivityExecutionRedisData();
        CrmBeanUtil.copyPropertiesIgnoreEmpty(executionEntity, redisData);
        VisitStepListener.VisitStepListenerCommittedData.copyClientData(redisData, clientData);
        redisData.setExecuteStatus(SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal());
        if(SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(executionEntity.getActivityType())){
            redisData.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COST.getVal());
        }else {
            redisData.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DISPLAY.getVal());
        }
        redisData.setActivityDate(resolveDate.format(CrmDateUtils.yyyyMMdd));
        redisData.setActivityYearMonth(resolveDate.format(CrmDateUtils.yyyyMM));
        redisData.setActivityYear(resolveDate.format(CrmDateUtils.yyyy));
        redisData.setActivityExecutionId(executionEntity.getId());
        redisData.setId(null);
        redisData.buildActivityRequireReqVoList(executionEntity.getActivityRequire());
        return redisData;
    }



}
