package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeMiniReqVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeRespVo;
import com.biz.crm.notice.service.ISfaNoticeService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 公告管理 
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
@Slf4j
@RestController
@RequestMapping("/sfaNoticeController")
@Api(tags = "公告管理 ")
public class SfaNoticeController {
    @Autowired
    private ISfaNoticeService sfaNoticeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaNoticeRespVo>> list(@RequestBody SfaNoticeReqVo sfaNoticeReqVo) {
        PageResult<SfaNoticeRespVo> result=sfaNoticeService.findList(sfaNoticeReqVo);
        return Result.ok(result);
    }

    /**
     * 列表
     */
    @ApiOperation(value = "查询小程序列表")
    @PostMapping("/miniList")
    @CrmLog
    public Result<PageResult<SfaNoticeRespVo>> miniList(@RequestBody SfaNoticeMiniReqVo sfaNoticeMiniReqVo) {
        PageResult<SfaNoticeRespVo> result=sfaNoticeService.findListByMiniPrg(sfaNoticeMiniReqVo);
        return Result.ok(result);
    }

    /**
     * 最新单条
     */
    @ApiOperation(value = "查询公告单条最新")
    @GetMapping("/miniNewNotice")
    @CrmLog
    public Result<SfaNoticeRespVo> miniNewNotice(){
        SfaNoticeRespVo respVo = sfaNoticeService.queryMiniPrgNew();
        return Result.ok(respVo);
    }

    @ApiOperation(value = "小程序详情",httpMethod = "GET")
    @GetMapping("/miniQuery")
    @CrmLog
    public Result<SfaNoticeRespVo> miniQuery(@RequestParam("id") String id) {
        SfaNoticeRespVo result=sfaNoticeService.queryMiniPrg(id);
        return Result.ok(result);
    }

    @ApiOperation(value = "小程序详情（上一页/下一页）",httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "upBelow", value = "翻页状态(1:上一页,0:下一页)", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/miniQueryUpBelow")
    @CrmLog
    public Result<SfaNoticeRespVo> miniQueryUpBelow(@RequestParam("id") String id,@RequestParam("upBelow") String upBelow){
        SfaNoticeRespVo result=sfaNoticeService.queryMiniPrgByUpBelow(id,upBelow);
        return Result.ok(result);
    }


    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaNoticeRespVo> query(@RequestBody SfaNoticeReqVo sfaNoticeReqVo) {
        SfaNoticeRespVo respVo=sfaNoticeService.query(sfaNoticeReqVo);
        return Result.ok(respVo);
    }


    /**
     * 查询
     */
    @ApiOperation(value = "查询公告详情")
    @GetMapping("/queryNoticeDetail")
    @CrmLog
    public Result<SfaNoticeRespVo> queryNoticeDetail(@RequestParam String id) {
        AssertUtils.isNotEmpty(id,"数据主键不能为空");
        SfaNoticeReqVo sfaNoticeReqVo = new SfaNoticeReqVo(){{
            this.setId(id);
        }};
        SfaNoticeRespVo respVo=sfaNoticeService.query(sfaNoticeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaNoticeReqVo sfaNoticeReqVo) {
        sfaNoticeService.save(sfaNoticeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaNoticeReqVo sfaNoticeReqVo) {
        sfaNoticeService.update(sfaNoticeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaNoticeService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaNoticeService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaNoticeService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
