package com.biz.crm.notice.mapper;

import com.biz.crm.notice.model.SfaNoticeFileEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeFileRespVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeFileReqVo;
import java.util.List;
import java.util.Map;

/**
 * 公告附件 
 * 
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
public interface SfaNoticeFileMapper extends BaseMapper<SfaNoticeFileEntity> {
    /**
     * 列表
     * @param page
     * @param sfaNoticeFileReqVo
     * @return
     */
    List<SfaNoticeFileRespVo> findList(Page<SfaNoticeFileRespVo> page, @Param("vo") SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 删除
     * @param sfaNoticeFileReqVo
     */
    void deleteProductsByParams(@Param("vo") SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 根据公告查附件集合
     * @param noticeCode
     * @return
     */
    List<SfaNoticeFileRespVo> findMiniList(String noticeCode);
}
