package com.biz.crm.notice.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 公告管理 实体类
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_notice")
@CrmTable(name = "sfa_notice", tableNote = "公告管理")
public class SfaNoticeEntity extends CrmExtTenEntity<SfaNoticeEntity> {

    /**
     * 公告编码 公告编码
     */
    @CrmColumn(name = "notice_code", length = 32, note = "公告编码 公告编码")
    private String noticeCode;
    /**
     * 公告标题 公告标题
     */
    @CrmColumn(name = "notice_title", length = 100, note = "公告标题 公告标题")
    private String noticeTitle;

    /**
     * 公告类型 公告类型
     */
    @CrmColumn(name = "notice_type", length = 32, note = "公告类型 公告类型")
    private String noticeType;

    /**
     * 有效开始时间 有效开始时间
     */
    @CrmColumn(name = "begin_date", length = 32, note = "有效开始时间 有效开始时间")
    private String beginDate;

    /**
     * 有效结束时间 有效结束时间
     */
    @CrmColumn(name = "end_date", length = 32, note = "有效结束时间 有效结束时间")
    private String endDate;

    /**
     * 公告内容 公告内容
     */
    @CrmColumn(name = "notice_content", length = 3000, note = "公告内容 公告内容")
    private String noticeContent;

}
