package com.biz.crm.notice.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 公告附件 实体类
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_notice_file")
@CrmTable(name = "sfa_notice_file", tableNote = "公告附件")
public class SfaNoticeFileEntity extends CrmExtTenEntity<SfaNoticeFileEntity> {

    /**
     * 附件名称 附件名称
     */
    @CrmColumn(name = "file_name", length = 100, note = "附件名称 附件名称")
    private String fileName;

    /**
     * 附件url路径 url地址
     */
    @CrmColumn(name = "url_path", length = 100, note = "附件url路径 url地址")
    private String urlPath;

    /**
     * 附件物理路径 附件物理路径
     */
    @CrmColumn(name = "real_path", length = 100, note = "附件物理路径 附件物理路径")
    private String realPath;

    /**
     * 公告编码 公告编码
     */
    @CrmColumn(name = "notice_code", length = 32, note = "公告编码 公告编码")
    private String noticeCode;

}
