package com.biz.crm.notice.service;

import com.biz.crm.notice.model.SfaNoticeReadEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;

import java.util.List;
import java.util.Map;

/**
 * 公告读取信息 接口
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
public interface ISfaNoticeReadService extends IService<SfaNoticeReadEntity> {

    /**
     * 列表
     * @param sfaNoticeReadReqVo
     * @return PageResult<SfaNoticeReadRespVo>
     */
    PageResult<SfaNoticeReadRespVo> findList(SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 查询
     * @param sfaNoticeReadReqVo
     * @return SfaNoticeReadRespVo
     */
    SfaNoticeReadRespVo query(SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 新增
     * @param noticeCode
     * @return
     */
    void save(String noticeCode);

    /**
     * 更新
     * @param sfaNoticeReadReqVo
     * @return
     */
    void update(SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

